// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_INFO_H_
#define _MARKELLA_INFO_H_

#include <string.h>

#include "git_sha.h"

#define MAR_MAJOR_VERSION 0
#define MAR_MINOR_VERSION 52

#define MAR_RELEASE "-alpha"
#define MAR_SPECIAL ""

#define MAR_NAME "markella"
#define MAR_NAME_MARKETING "Markella"
#define MAR_COMPANY_URL "https://www.grafmin.gr/"
#define MAR_WEBSITE_URL "https://www.grafmin.gr/markella"
#define MAR_COPYRIGHT "Copyright (c) 2023-2025 Giorgos Vougioukas"

#define MAR_STRINGIFY_HELPER(x) #x
#define MAR_STRINGIFY(x) MAR_STRINGIFY_HELPER(x)

#define MAR_NAKED_VERSION \
  MAR_STRINGIFY(MAR_MAJOR_VERSION) \
  "." MAR_STRINGIFY(MAR_MINOR_VERSION) \
  MAR_RELEASE MAR_SPECIAL

#define MAR_FULL_VERSION \
  MAR_NAME_MARKETING " " MAR_NAKED_VERSION

#define MAR_GIT_SHA MAR_STRINGIFY(GIT_SHA)

#define MAR_TIMESTAMP __DATE__ " " __TIME__

inline bool MAR_IsStableRelease()
{
  if (strlen(MAR_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define MAR_ARCH "x64"
  #elif defined(_M_IX86)
    #define MAR_ARCH "x86"
  #else
    #define MAR_ARCH "unk"
  #endif
#elif defined(__linux__) && ((defined(__clang__) || defined(__GNUC__)))
  #if defined(__amd64__) || defined(__X86_64__)
    #define MAR_ARCH "amd64"
  #elif defined(__i386__)
    #define MAR_ARCH "i686"
  #else
    #define MAR_ARCH "unk"
  #endif
#elif defined(__APPLE__) && ((defined(__clang__) || defined(__GNUC__)))
  #if defined(__amd64__) || defined(__X86_64__)
    #define MAR_ARCH "x86-64"
  #elif defined(__i386__)
    #define MAR_ARCH "i386"
  #else
    #define MAR_ARCH "unk"
  #endif
#endif

#endif // _MARKELLA_INFO_H_
