// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "change_wnd.h"
#include "app_info.h"
#include "surface_wnd.h"

MAR_ChangeWnd::MAR_ChangeWnd()
  : m_hwnd(NULL)
  , m_find(NULL)
  , m_change(NULL)
  , m_matchcase(NULL)
  , m_matchword(NULL)
{}

MAR_ChangeWnd::~MAR_ChangeWnd()
{}

HWND MAR_ChangeWnd::Handle() const
{
  return m_hwnd;
}

void MAR_ChangeWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  m_find = GetDlgItem(m_hwnd, IDC_EDIT1);
  m_change = GetDlgItem(m_hwnd, IDC_EDIT2);
  m_matchcase = GetDlgItem(m_hwnd, IDC_CHECK1);
  m_matchword = GetDlgItem(m_hwnd, IDC_CHECK2);
  SendMessage(m_matchcase, BM_SETCHECK, BST_CHECKED, 0);
  SendMessage(m_matchword, BM_SETCHECK, BST_CHECKED, 0);

  int x = GetPrivateProfileInt(MAR_NAME, "change_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(MAR_NAME, "change_wnd_y", 50, g_inipath.Get());
  SetWindowPos(m_hwnd, NULL, x, y, 0, 0, SWP_NOSIZE | SWP_NOZORDER | SWP_NOACTIVATE);
}

INT_PTR MAR_ChangeWnd::OnClose(WPARAM wparam, LPARAM lparam)
{
  DestroyWindow(m_hwnd);
  return 0;
}

void MAR_ChangeWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  RECT r;
  GetWindowRect(m_hwnd, &r);

  WDL_FastString rleft, rtop, rwidth, rheight;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);

  WritePrivateProfileString(MAR_NAME, "change_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(MAR_NAME, "change_wnd_y", rtop.Get(), g_inipath.Get());

  if (g_changewnd) { delete g_changewnd; g_changewnd = NULL; }
}

void MAR_ChangeWnd::OnSysCommand(WPARAM wparam, LPARAM lparam)
{
  if (wparam == SC_CLOSE)
  {
    SendMessage(m_hwnd, WM_CLOSE, 0, 0);
  }
}

void MAR_ChangeWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch(LOWORD(wparam))
  {
  case IDOK:
    {
      bool case_sensitive = false;
      bool match_whole_word = false;
      LRESULT chk = SendMessage(m_matchcase, BM_GETCHECK, 0, 0);
      if (chk == BST_CHECKED) case_sensitive = true;
      chk = SendMessage(m_matchword, BM_GETCHECK, 0, 0);
      if (chk == BST_CHECKED) match_whole_word = true;

      char texta[2048], textb[2048];
      GetWindowText(m_change, textb, sizeof(textb));
      int len = GetWindowText(m_find, texta, sizeof(texta));
      if (len && g_surfacewnd)
      {
        g_surfacewnd->ChangeKeyWord(texta, textb, case_sensitive, match_whole_word);
      }

      SendMessage(m_hwnd, WM_CLOSE, 0, 0);
    } break;
  case IDCANCEL:
    {
      SendMessage(m_hwnd, WM_CLOSE, 0, 0);
    } break;
  }
}

WDL_DLGRET MAR_ChangeWnd::ChangeWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  MAR_ChangeWnd *self = (MAR_ChangeWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (MAR_ChangeWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->ChangeWndLoop(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET MAR_ChangeWnd::ChangeWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_CLOSE: return OnClose(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_SYSCOMMAND: OnSysCommand(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
  }

  return 0;
}
