// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_CHAR_ENCODING_H_
#define _MARKELLA_CHAR_ENCODING_H_

#include <WDL/wdlutf8.h>
#include <WDL/wdlstring.h>

#define MAR_TEXTLEN 2048
#define MAR_STRING_AND_CHARACTER_LITERAL_PREFIX(x) L##x
#define MAR_WIDE(x) MAR_STRING_AND_CHARACTER_LITERAL_PREFIX(x)

class MAR_WideToMultiByteStr
{
public:
  MAR_WideToMultiByteStr()
    : m_len(0)
  {}

  MAR_WideToMultiByteStr(const WDL_WCHAR *text)
  {
    m_len = WDL_WideToMBStr(m_textbuf, text, sizeof(m_textbuf));
  }

  ~MAR_WideToMultiByteStr() {}

  void Set(const WDL_WCHAR *text)
  {
    m_len = WDL_WideToMBStr(m_textbuf, text, sizeof(m_textbuf));
  }

  const char *Get() const
  {
    return m_len ? m_textbuf : "";
  }

  int GetLength() const
  {
    return m_len;
  }

private:
  char m_textbuf[MAR_TEXTLEN];
  int m_len;
};

class MAR_MultiByteToWideStr
{
public:
  MAR_MultiByteToWideStr()
    : m_len(0)
  {}

  MAR_MultiByteToWideStr(const char *text)
  {
    m_len = WDL_MBtoWideStr(m_textbuf, text, sizeof(m_textbuf));
  }

  MAR_MultiByteToWideStr(const WDL_String& str)
  {
    m_len = WDL_MBtoWideStr(m_textbuf, str.Get(), sizeof(m_textbuf));
  }

  MAR_MultiByteToWideStr(const WDL_FastString& str)
  {
    m_len = WDL_MBtoWideStr(m_textbuf, str.Get(), sizeof(m_textbuf));
  }

  ~MAR_MultiByteToWideStr() {}

  void Set(const char *text)
  {
    m_len = WDL_MBtoWideStr(m_textbuf, text, sizeof(m_textbuf));
  }

  void Set(const WDL_String& str)
  {
    m_len = WDL_MBtoWideStr(m_textbuf, str.Get(), sizeof(m_textbuf));
  }

  void Set(const WDL_FastString& str)
  {
    m_len = WDL_MBtoWideStr(m_textbuf, str.Get(), sizeof(m_textbuf));
  }

  const WDL_WCHAR *Get() const
  {
    return m_len ? m_textbuf : MAR_WIDE("");
  }

  int GetLength() const
  {
    return m_len;
  }

private:
  WDL_WCHAR m_textbuf[MAR_TEXTLEN];
  int m_len;
};

#endif // _MARKELLA_CHAR_ENCODING_H_
