// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "folders.h"

MAR_Folders::MAR_Folders()
{}

MAR_Folders::~MAR_Folders()
{
  m_rfs.Empty(true);
}

void MAR_Folders::Open(const char *path)
{
  bool found = false;

  for (int i = 0; i < m_rfs.GetSize(); i++)
  {
    const MAR_RootFolder *rf = m_rfs.Get(i);
    if (rf)
    {
      if (!wdl_filename_cmp(path, rf->scan.GetPath()))
      {
        found = true; break;
      }
    }
  }

  if (!found)
  {
    MAR_RootFolder *rf = new WDL_NEW MAR_RootFolder;
    if (rf)
    {
      rf->name.Set(path);
      rf->scan.Open(path);
      m_rfs.Add(rf);
    }
  }
}

int MAR_Folders::GetSize() const
{
  return m_rfs.GetSize();
}

MAR_RootFolder *MAR_Folders::Get(int index) const
{
  if (WDL_NORMALLY(index < m_rfs.GetSize()))
  {
    MAR_RootFolder *rf = m_rfs.Get(index);
    if (rf) return rf;
  }

  return NULL;
}
