// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_FOLDERS_H_
#define _MARKELLA_FOLDERS_H_

#include "definitions.h"
#include "scan_files.h"

#include <WDL/ptrlist.h>
#include <WDL/wdlstring.h>

struct MAR_RootFolder
{
  WDL_FastString name;
  MAR_ScanFiles scan;
};

class MAR_Folders
{
public:
  MAR_Folders();
  ~MAR_Folders();

  void Open(const char *path);

  int GetSize() const;
  MAR_RootFolder *Get(int index) const;

private:
  WDL_PtrList<MAR_RootFolder> m_rfs;
};

#endif // _MARKELLA_FOLDERS_H_
