// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_KEYMAP_H_
#define _MARKELLA_KEYMAP_H_

#include <WDL/heapbuf.h>

struct MAR_HotKey
{
  bool virkey;
  unsigned char key;
  bool ctrl;
  bool menu;
  bool shift;
  void (*action)();
};

class MAR_KeyMap
{
public:
  MAR_KeyMap();
  ~MAR_KeyMap();

  int GetHotKeyDownSize() const;
  MAR_HotKey *GetHotKeyDown() const;
  int GetHotKeyUpSize() const;
  MAR_HotKey *GetHotKeyUp() const;

private:
  WDL_TypedBuf<MAR_HotKey> m_hotkeydown;
  WDL_TypedBuf<MAR_HotKey> m_hotkeyup;
};

#endif // _MARKELLA_KEYMAP_H_
