// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_LICENSE_WND_H_
#define _MARKELLA_LICENSE_WND_H_

#include "definitions.h"
#include "app_info.h"

#include <WDL/wingui/wndsize.h>

class MAR_LicenseWnd
{
public:
  MAR_LicenseWnd()
    : m_hwnd(NULL)
  {}

  ~MAR_LicenseWnd()
  {}

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET LicenseWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
#ifdef _WIN32
  INT_PTR OnCtlColorStatic(UINT msg, WPARAM wparam, LPARAM lparam);
#endif
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET LicenseWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_WndSizer m_resize;
};

#endif // _MARKELLA_LICENSE_WND_H_
