// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_MAIN_WND_H_
#define _MARKELLA_MAIN_WND_H_

#include "definitions.h"
#include "folders.h"

#include <WDL/wingui/wndsize.h>
#include <WDL/wingui/virtwnd.h>
#include <WDL/wingui/virtwnd-controls.h>

class MAR_MainWnd
{
public:
  MAR_MainWnd();
  ~MAR_MainWnd();

  HWND Handle() const { return m_hwnd; }

  void ShowProjects();
  void ShowSwitch();
  void SetTitle(const char *title);
  void DisplayFileName();
  void ToggleFullscreen();
  void ToggleLineNumber();
  void ToggleFileName();
  void ToggleRuler();
  void ToggleWhitespace();
  void FindKeyWord();
  void ChangeKeyWord();
  void GoToLine();
  void SwitchToPreviousFile();
  void ReopenFile();

  const char *GetOrigTitle() const;

  int GetProjectsSize() const;
  MAR_RootFolder *GetProject(int index) const;

  static WDL_DLGRET MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnMove(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  INT_PTR OnCtrlColorEdit(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnActivateApp(WPARAM wparam, LPARAM lparam);
  void OnNCLButtonDown(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET MainWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewTreeProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewListProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewEditProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HWND m_line;
  HWND m_surface;
  bool m_splitter;

  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  WDL_VWnd_Painter m_painter;
  HMENU m_mainmenu;

  WDL_FastString m_strbuf;

  LICE_IFont *m_font;
  HBRUSH m_brush;

  WDL_FastString m_titleorig;

  bool m_fullscreen;
  LONG_PTR m_style;
  LONG_PTR m_exstyle;
  bool m_maximized;
  bool m_showproject;
  bool m_linenumber;
  int m_bg;

  MAR_Folders m_folders;
  bool m_filename;
};

#endif // _MARKELLA_MAIN_WND_H_
