// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "definitions.h"
#include "about_wnd.h"
#include "changelog_wnd.h"
#include "license_wnd.h"
#include "main_wnd.h"
#include "preferences_wnd.h"
#include "surface_wnd.h"
#include "folders_wnd.h"
#include "switch_wnd.h"
#include "volissos.h"
#include "keymap.h"

#include <WDL/wdlutf8.h>

// VK_OEM_1: semicolon (0xBA)
// VK_OEM_2: slash (0xBF)
// VK_OEM_3: tilde (0xC0)
// VK_OEM_4: left bracket (0xDB)
// VK_OEM_5: backslash (0xDC)
// VK_OEM_6: right bracket (0xDD)
// VK_OEM_7: quote (0xDE)
// VK_OEM_PLUS: equal (0xBB)
// VK_OEM_MINUS: dash (0xBD)
// VK_OEM_COMMA: comma (0xBC)
// VK_OEM_PERIOD: period (0xBE)

int MAR_ProcessMessage(MSG *msg)
{
  if (g_folderswnd && (msg->hwnd == g_folderswnd->Handle() || IsChild(g_folderswnd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_folderswnd->Handle(), IDC_TREE1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                HWND tree = GetDlgItem(g_folderswnd->Handle(), IDC_TREE1);
                HTREEITEM it = TreeView_GetSelection(tree);
                if (it)
                {
                  char text[2048];
                  TVITEM tvi;
                  tvi.hItem = it;
                  tvi.mask = TVIF_TEXT|TVIF_PARAM;
                  tvi.pszText = (char *)text;
                  tvi.cchTextMax = (int)sizeof(text);
                  if (TreeView_GetItem(tree, &tvi))
                  {
                    if (!strcmp((const char *)tvi.lParam, "file"))
                    {
                      if (g_volissos) g_volissos->Open(text);
                    }
                  }
                }
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DELETE)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_folderswnd->RemoveSelection();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_DELETE)
          {
            if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_folderswnd->RemoveAll();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_UP)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                HWND tree = GetDlgItem(g_folderswnd->Handle(), IDC_TREE1);
                HWND edit = GetDlgItem(g_folderswnd->Handle(), IDC_EDIT1);
                HTREEITEM it = TreeView_GetSelection(tree);
                if (it == TreeView_GetRoot(tree)) SetFocus(edit);
                else SendMessage(tree, WM_KEYDOWN, VK_UP, 0);
              }

              return 1;
            }
          }
        }
        if (msg->wParam == 'D')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              char text[2048];
              HWND edit = GetDlgItem(g_folderswnd->Handle(), IDC_EDIT1);
              GetWindowText(edit, text, sizeof(text));
              SendMessage(edit, EM_SETSEL, 0, -1);
              SetFocus(edit);
            }

            return 1;
          }
        }
      }
    }
    if (GetFocus() == GetDlgItem(g_folderswnd->Handle(), IDC_EDIT1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_DOWN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                HWND tree = GetDlgItem(g_folderswnd->Handle(), IDC_TREE1);
                SetFocus(tree);
              }

              return 1;
            }
          }
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                char text[2048];
                HWND edit = GetDlgItem(g_folderswnd->Handle(), IDC_EDIT1);
                GetWindowText(edit, text, sizeof(text));
                g_folderswnd->Search(text);
              }

              return 1;
            }
          }
        }
        if (msg->wParam == 'D')
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            (GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              char text[2048];
              HWND edit = GetDlgItem(g_folderswnd->Handle(), IDC_EDIT1);
              GetWindowText(edit, text, sizeof(text));
              SendMessage(edit, EM_SETSEL, 0, -1);
              SetFocus(edit);
            }

            return 1;
          }
        }
      }
    }
  }

  if (g_switchwnd && (msg->hwnd == g_switchwnd->Handle() || IsChild(g_switchwnd->Handle(), msg->hwnd)))
  {
    if (GetFocus() == GetDlgItem(g_switchwnd->Handle(), IDC_LIST1))
    {
      if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
      {
        if (msg->lParam & FVIRTKEY)
        {
          if (msg->wParam == VK_RETURN)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_switchwnd->SelectGapBuffer();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_TAB)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_switchwnd->SelectNextGapBuffer();
              }

              return 1;
            }
          }
          if (msg->wParam == VK_TAB)
          {
            if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
              (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
              !(GetAsyncKeyState(VK_MENU) & 0x8000))
            {
              if (!GetCapture())
              {
                g_switchwnd->SelectPreviousGapBuffer();
              }

              return 1;
            }
          }
        }
      }
    }
  }

  if (g_mainwnd && (msg->hwnd == g_mainwnd->Handle() || IsChild(g_mainwnd->Handle(), msg->hwnd)))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
          msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd->Handle())
      {
        //InvalidateRect(g_mainwnd->Handle(), NULL, FALSE);
      }
    }

    if (msg->message == WM_CHAR)
    {
      if ((!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
        !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
        !(GetAsyncKeyState(VK_MENU) & 0x8000)) ||
        (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
        (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
        !(GetAsyncKeyState(VK_MENU) & 0x8000)))
      {
        SendMessage(g_surfacewnd->Handle(), WM_CHAR, msg->wParam, msg->lParam);
      }
    }

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    //if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN || msg->message == WM_CHAR)
    {
      if (msg->lParam & FVIRTKEY)
      {
        for (int i = 0; i < g_keymap->GetHotKeyDownSize(); i++)
        {
          const MAR_HotKey *hk = g_keymap->GetHotKeyDown();

          if (hk)
          {
            if (hk[i].virkey && msg->wParam == hk[i].key)
            {
              if ((!!(GetAsyncKeyState(VK_CONTROL) & 0x8000) == hk[i].ctrl) &&
                (!!(GetAsyncKeyState(VK_SHIFT) & 0x8000) == hk[i].shift) &&
                (!!(GetAsyncKeyState(VK_MENU) & 0x8000) == hk[i].menu))
              {
                if (!GetCapture())
                {
                  hk[i].action();
                }

                return 1;
              }
            }
          }
        }
      } // FVIRTKEY

      for (int i = 0; i < g_keymap->GetHotKeyDownSize(); i++)
      {
        const MAR_HotKey *hk = g_keymap->GetHotKeyDown();

        if (hk)
        {
          if (!hk[i].virkey && msg->wParam == hk[i].key)
          {
            if ((!!(GetAsyncKeyState(VK_CONTROL) & 0x8000) == hk[i].ctrl) &&
              (!!(GetAsyncKeyState(VK_SHIFT) & 0x8000) == hk[i].shift) &&
              (!!(GetAsyncKeyState(VK_MENU) & 0x8000) == hk[i].menu))
            {
              if (!GetCapture())
              {
                hk[i].action();
              }

              return 1;
            }
          }
        }
      }
    }

    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP /* || msg->message == WM_CHAR */)
    {
      if (msg->lParam & FVIRTKEY)
      {
        for (int i = 0; i < g_keymap->GetHotKeyUpSize(); i++)
        {
          const MAR_HotKey *hk = g_keymap->GetHotKeyUp();

          if (hk)
          {
            if (hk[i].virkey && msg->wParam == hk[i].key)
            {
              if ((!!(GetAsyncKeyState(VK_CONTROL) & 0x8000) == hk[i].ctrl) &&
                (!!(GetAsyncKeyState(VK_SHIFT) & 0x8000) == hk[i].shift) &&
                (!!(GetAsyncKeyState(VK_MENU) & 0x8000) == hk[i].menu))
              {
                if (!GetCapture())
                {
                  hk[i].action();
                }

                return 1;
              }
            }
          }
        }
      } // FVIRTKEY

      for (int i = 0; i < g_keymap->GetHotKeyUpSize(); i++)
      {
        const MAR_HotKey *hk = g_keymap->GetHotKeyUp();

        if (hk)
        {
          if (!hk[i].virkey && msg->wParam == hk[i].key)
          {
            if ((!!(GetAsyncKeyState(VK_CONTROL) & 0x8000) == hk[i].ctrl) &&
              (!!(GetAsyncKeyState(VK_SHIFT) & 0x8000) == hk[i].shift) &&
              (!!(GetAsyncKeyState(VK_MENU) & 0x8000) == hk[i].menu))
            {
              if (!GetCapture())
              {
                hk[i].action();
              }

              return 1;
            }
          }
        }
      }
    }
  }

  return 0;
}

void MAR_RunMessageLoop()
{
#if defined(_WIN32)
  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = MAR_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (g_mainwnd)
    {
      if (IsDialogMessage(g_mainwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_changelogwnd)
    {
      if (IsDialogMessage(g_changelogwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_prefwnd)
    {
      if (IsDialogMessage(g_prefwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_licwnd)
    {
      if (IsDialogMessage(g_licwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_aboutwnd)
    {
      if (IsDialogMessage(g_aboutwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_folderswnd)
    {
      if (IsDialogMessage(g_folderswnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_switchwnd)
    {
      if (IsDialogMessage(g_switchwnd->Handle(), &msg))
      {
        continue;
      }
    }

    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
#else
  for (;;)
  {
    MSG msg = { 0, };
    int x = MAR_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }
#endif
}
