// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_PREFERENCES_WND_H_
#define _MARKELLA_PREFERENCES_WND_H_

#include "definitions.h"
#include "editor.h"
#include "app_info.h"

#include <WDL/wingui/wndsize.h>
#include <WDL/wingui/virtwnd.h>

class MAR_PreferencesWnd
{
public:
  MAR_PreferencesWnd();
  ~MAR_PreferencesWnd();

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET PreferencesWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnToggleFocus(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET PreferencesWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_WndSizer m_resize;
  WDL_VWnd_Painter m_painter;
  MAR_PreviewEditor m_preview;
  MAR_PreferencesEditor m_editor;
};

#endif // _MARKELLA_PREFERENCES_WND_H_
