rem Cleanup
rem =======

rem del *.zip
rem del *.exe
rem del changelog.txt

copy ..\doc\changelog.txt .\

rem markella x86 (installer)
rem ========================

makensis markella_x86.nsi

rem markella x64 (installer)
rem ========================

makensis markella_x64.nsi

rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define MAR_MAJOR_VERSION " ..\src\markella\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~27,1%

for /f "delims=" %%a in ('findstr /b /c:"#define MAR_MINOR_VERSION " ..\src\markella\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~27,2%

for /f "delims=" %%a in ('findstr /b /c:"#define MAR_RELEASE " ..\src\markella\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~22%

rem markella x86 (portable)
rem =====================

rem Note: -mx=1 (fastest), -mx=3 (fast), nothing or -mx=5 (normal)

del markella-%maj%.%min%%rel%-x86.zip
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\markella.exe
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\ext\
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\skin\
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\*.dll
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\changelog.txt
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\license.txt
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\documentation.txt
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x86.zip portable
7z d -r markella-%maj%.%min%%rel%-x86.zip *.lib
7z d -r markella-%maj%.%min%%rel%-x86.zip *.pdb
7z d -r markella-%maj%.%min%%rel%-x86.zip *.exp
7z t markella-%maj%.%min%%rel%-x86.zip * -r

rem markella x64 (portable)
rem =====================

del markella-%maj%.%min%%rel%-x64.zip
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\markella.exe
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\ext\
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\skin\
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\*.dll
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\changelog.txt
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\license.txt
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\documentation.txt
7z a -tzip -mx=1 markella-%maj%.%min%%rel%-x64.zip portable
7z d -r markella-%maj%.%min%%rel%-x64.zip *.lib
7z d -r markella-%maj%.%min%%rel%-x64.zip *.pdb
7z d -r markella-%maj%.%min%%rel%-x64.zip *.exp
7z t markella-%maj%.%min%%rel%-x64.zip * -r

cd ..
git archive --format=zip --prefix=GV-350/ HEAD > pack\markella-%maj%.%min%%rel%-src.zip
git archive --format=tar.gz --prefix=GV-350/ HEAD > pack\markella-%maj%.%min%%rel%-src.tar.gz

pause
