// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_DEFINITIONS_H_
#define _MARKELLA_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include <WDL/swell/swell.h>
#include <WDL/swell/swell-functions.h>
#endif

#include "res/resource.h"

#include <WDL/wdltypes.h>
#include <WDL/win32_utf8.h>
#include <WDL/wdlstring.h>

class MAR_AboutWnd;
class MAR_ChangelogWnd;
class MAR_LicenseWnd;
class MAR_MainWnd;
class MAR_PreferencesWnd;
class MAR_KeyMap;
class LICE_IBitmap;
class MAR_SurfaceWnd;
class MAR_LineWnd;
class MAR_Volissos;
class MAR_Preferences;
class MAR_FoldersWnd;
class MAR_SwitchWnd;
class MAR_FindWnd;
class MAR_ChangeWnd;
class MAR_GoToWnd;

extern HINSTANCE g_inst;
extern UINT g_scrollmessage;
extern bool g_hasrequestedquit;

extern WDL_FastString g_args;
extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;
extern WDL_FastString g_textext;

extern MAR_Volissos *g_volissos;
extern MAR_KeyMap *g_keymap;
extern MAR_Preferences *g_preferences;

extern MAR_MainWnd *g_mainwnd;
extern MAR_LicenseWnd *g_licwnd;
extern MAR_ChangelogWnd *g_changelogwnd;
extern MAR_PreferencesWnd *g_prefwnd;
extern MAR_AboutWnd *g_aboutwnd;
extern MAR_SurfaceWnd *g_surfacewnd;
extern MAR_LineWnd *g_linewnd;
extern MAR_FoldersWnd *g_folderswnd;
extern MAR_SwitchWnd *g_switchwnd;
extern MAR_FindWnd *g_findwnd;
extern MAR_ChangeWnd *g_changewnd;
extern MAR_GoToWnd *g_gotownd;

extern LICE_IBitmap *g_scrollbar;

extern void MAR_RunMessageLoop();
extern int MAR_ProcessMessage(MSG *msg);
extern WDL_DLGRET MAR_GotoLineWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET MAR_GotoLineOffsetWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

#endif // _MARKELLA_DEFINITIONS_H_
