// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "folders_wnd.h"
#include "app_info.h"
#include "app_timers.h"
#include "volissos.h"
#include "folders.h"

MAR_FoldersWnd::MAR_FoldersWnd()
  : m_hwnd(NULL)
  , m_tree(NULL)
{}

MAR_FoldersWnd::~MAR_FoldersWnd()
{}

HWND MAR_FoldersWnd::Handle() const
{
  return m_hwnd;
}

void MAR_FoldersWnd::Search(const char *text)
{
  TreeView_DeleteAllItems(m_tree);
  int textlen = (int)strlen(text);
  if (textlen)
  {
    HTREEITEM folder = NULL;
    HTREEITEM file = NULL;
    m_tvinsert.hParent = NULL;
    m_tvinsert.hInsertAfter = TVI_LAST;
    m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
    m_tvinsert.item.pszText = (char *)"Root";
    m_tvinsert.item.cchTextMax = (int)strlen("Root");
    m_tvinsert.item.lParam = (LPARAM)"root";
    TreeView_InsertItem(m_tree, &m_tvinsert);
    folder = TreeView_GetChild(m_tree, TVI_ROOT);

    if (WDL_NORMALLY(g_mainwnd))
    {
      for (int i = 0; i < g_mainwnd->GetProjectsSize(); i++)
      {
        const MAR_RootFolder *rf = g_mainwnd->GetProject(i);
        if (rf)
        {
          m_tvinsert.hParent = folder;
          m_tvinsert.hInsertAfter = TVI_LAST;
          m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
          m_tvinsert.item.pszText = (char *)rf->name.Get();
          m_tvinsert.item.cchTextMax = rf->name.GetLength();
          m_tvinsert.item.lParam = (LPARAM)"folder";
          file = TreeView_InsertItem(m_tree, &m_tvinsert);

          for (int j = 0; j < rf->scan.files.GetSize(); j++)
          {
            WDL_FastString *fn = rf->scan.files.Get(j);
            if (fn)
            {
              for (int k = 0; k < fn->GetLength() - textlen; k++)
              {
                if (!wdl_filename_cmpn(text, &fn->Get()[k], textlen))
                {
                  m_tvinsert.hParent = file;
                  m_tvinsert.hInsertAfter = TVI_LAST;
                  m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
                  m_tvinsert.item.pszText = (char *)fn->Get();
                  m_tvinsert.item.cchTextMax = fn->GetLength();
                  m_tvinsert.item.lParam = (LPARAM)"file";
                  TreeView_InsertItem(m_tree, &m_tvinsert);
                  break;
                }
              }
            }
          }
        }
      }

      TreeView_Expand(m_tree, file, TVE_EXPAND);
      TreeView_Expand(m_tree, folder, TVE_EXPAND);
      TreeView_Expand(m_tree, TVI_ROOT, TVE_EXPAND);
    }
  }
  else
  {
    HTREEITEM folder = NULL;
    HTREEITEM file = NULL;
    m_tvinsert.hParent = NULL;
    m_tvinsert.hInsertAfter = TVI_LAST;
    m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
    m_tvinsert.item.pszText = (char *)"Root";
    m_tvinsert.item.cchTextMax = (int)strlen("Root");
    m_tvinsert.item.lParam = (LPARAM)"root";
    TreeView_InsertItem(m_tree, &m_tvinsert);
    folder = TreeView_GetChild(m_tree, TVI_ROOT);

    if (WDL_NORMALLY(g_mainwnd))
    {
      for (int i = 0; i < g_mainwnd->GetProjectsSize(); i++)
      {
        const MAR_RootFolder *rf = g_mainwnd->GetProject(i);
        if (rf)
        {
          m_tvinsert.hParent = folder;
          m_tvinsert.hInsertAfter = TVI_LAST;
          m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
          m_tvinsert.item.pszText = (char *)rf->name.Get();
          m_tvinsert.item.cchTextMax = rf->name.GetLength();
          m_tvinsert.item.lParam = (LPARAM)"folder";
          file = TreeView_InsertItem(m_tree, &m_tvinsert);

          for (int j = 0; j < rf->scan.files.GetSize(); j++)
          {
            const WDL_FastString *fn = rf->scan.files.Get(j);
            if (fn)
            {
              m_tvinsert.hParent = file;
              m_tvinsert.hInsertAfter = TVI_LAST;
              m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
              m_tvinsert.item.pszText = (char *)fn->Get();
              m_tvinsert.item.cchTextMax = fn->GetLength();
              m_tvinsert.item.lParam = (LPARAM)"file";
              TreeView_InsertItem(m_tree, &m_tvinsert);
            }
          }
        }
      }

      TreeView_Expand(m_tree, file, TVE_EXPAND);
      TreeView_Expand(m_tree, folder, TVE_EXPAND);
      TreeView_Expand(m_tree, TVI_ROOT, TVE_EXPAND);
    }
  }
}

void MAR_FoldersWnd::RemoveSelection()
{
  HTREEITEM it = TreeView_GetSelection(m_tree);
  if (it) TreeView_DeleteItem(m_tree, it);
}

void MAR_FoldersWnd::RemoveAll()
{
  TreeView_DeleteAllItems(m_tree);
  m_tvinsert.hParent = NULL;
  m_tvinsert.hInsertAfter = TVI_LAST;
  m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
  m_tvinsert.item.pszText = (char *)"Root";
  m_tvinsert.item.cchTextMax = (int)strlen("Root");
  m_tvinsert.item.lParam = (LPARAM)"root";
  TreeView_InsertItem(m_tree, &m_tvinsert);
}

void MAR_FoldersWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  m_edit = GetDlgItem(m_hwnd, IDC_EDIT1);
  m_tree = GetDlgItem(m_hwnd, IDC_TREE1);
  WDL_UTF8_HookTreeView(m_tree);

  m_resize.init(m_hwnd);
  m_resize.init_itemhwnd(m_edit, 0.0f, 0.0f, 1.0f, 0.0f);
  m_resize.init_itemhwnd(m_tree, 0.0f, 0.0f, 1.0f, 1.0f);

  int x = GetPrivateProfileInt(MAR_NAME, "folders_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(MAR_NAME, "folders_wnd_y", 50, g_inipath.Get());
  int w = GetPrivateProfileInt(MAR_NAME, "folders_wnd_w", 800, g_inipath.Get());
  int h = GetPrivateProfileInt(MAR_NAME, "folders_wnd_h", 600, g_inipath.Get());
  SetWindowPos(m_hwnd, NULL, x, y, w, h, SWP_NOZORDER | SWP_NOACTIVATE);

  TreeView_SetBkColor(m_tree, RGB(0, 0, 0));
  TreeView_SetTextColor(m_tree, RGB(192, 192, 192));

  TreeView_DeleteAllItems(m_tree);

  HTREEITEM folder = NULL;
  HTREEITEM file = NULL;
  m_tvinsert.hParent = NULL;
  m_tvinsert.hInsertAfter = TVI_LAST;
  m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
  m_tvinsert.item.pszText = (char *)"Root";
  m_tvinsert.item.cchTextMax = (int)strlen("Root");
  m_tvinsert.item.lParam = (LPARAM)"root";
  TreeView_InsertItem(m_tree, &m_tvinsert);
  folder = TreeView_GetChild(m_tree, TVI_ROOT);

  if (WDL_NORMALLY(g_mainwnd))
  {
    for (int i = 0; i < g_mainwnd->GetProjectsSize(); i++)
    {
      const MAR_RootFolder *rf = g_mainwnd->GetProject(i);
      if (rf)
      {
        m_tvinsert.hParent = folder;
        m_tvinsert.hInsertAfter = TVI_LAST;
        m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
        m_tvinsert.item.pszText = (char *)rf->name.Get();
        m_tvinsert.item.cchTextMax = rf->name.GetLength();
        m_tvinsert.item.lParam = (LPARAM)"folder";
        file = TreeView_InsertItem(m_tree, &m_tvinsert);

        for (int j = 0; j < rf->scan.files.GetSize(); j++)
        {
          const WDL_FastString *fn = rf->scan.files.Get(j);
          if (fn)
          {
            m_tvinsert.hParent = file;
            m_tvinsert.hInsertAfter = TVI_LAST;
            m_tvinsert.item.mask = TVIF_TEXT|TVIF_PARAM;
            m_tvinsert.item.pszText = (char *)fn->Get();
            m_tvinsert.item.cchTextMax = fn->GetLength();
            m_tvinsert.item.lParam = (LPARAM)"file";
            TreeView_InsertItem(m_tree, &m_tvinsert);
          }
        }
      }
    }

    TreeView_Expand(m_tree, file, TVE_EXPAND);
    TreeView_Expand(m_tree, folder, TVE_EXPAND);
    TreeView_Expand(m_tree, TVI_ROOT, TVE_EXPAND);
  }

  //SetTimer(m_hwnd, MAR_FOLDERS_UPDATE_ID, MAR_FOLDERS_UPDATE_MS, FALSE);
}

INT_PTR MAR_FoldersWnd::OnClose(WPARAM wparam, LPARAM lparam)
{
  DestroyWindow(m_hwnd);
  return 0;
}

void MAR_FoldersWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  //KillTimer(m_hwnd, MAR_FOLDERS_UPDATE_ID);

  RECT r;
  GetWindowRect(m_hwnd, &r);

  WDL_FastString rleft, rtop, rwidth, rheight;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);
  rwidth.SetFormatted(32, "%d", r.right - r.left);
  rheight.SetFormatted(32, "%d", r.bottom - r.top);

  WritePrivateProfileString(MAR_NAME, "folders_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(MAR_NAME, "folders_wnd_y", rtop.Get(), g_inipath.Get());
  WritePrivateProfileString(MAR_NAME, "folders_wnd_w", rwidth.Get(), g_inipath.Get());
  WritePrivateProfileString(MAR_NAME, "folders_wnd_h", rheight.Get(), g_inipath.Get());

  if (g_folderswnd) { delete g_folderswnd; g_folderswnd = NULL; }
}

void MAR_FoldersWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  if (wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();

    //InvalidateRect(m_hwnd, NULL, FALSE);
  }
}

void MAR_FoldersWnd::OnSysCommand(WPARAM wparam, LPARAM lparam)
{
  if (wparam == SC_CLOSE)
  {
    SendMessage(m_hwnd, WM_CLOSE, 0, 0);
  }
}

void MAR_FoldersWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch (LOWORD(wparam))
  {
  case IDCANCEL:
    {
      SendMessage(m_hwnd, WM_CLOSE, 0, 0);
    }
    break;
  }
}

void MAR_FoldersWnd::OnPaint(WPARAM wparam, LPARAM lparam)
{
  PAINTSTRUCT ps;
  HDC dc = BeginPaint(m_hwnd, &ps);
  EndPaint(m_hwnd, &ps);
}

void MAR_FoldersWnd::OnLButtonDown(WPARAM wparam, LPARAM lparam)
{
  SetCapture(m_hwnd);

  POINT pt;
  pt.x = GET_X_LPARAM(lparam);
  pt.y = GET_Y_LPARAM(lparam);
}

void MAR_FoldersWnd::OnLButtonUp(WPARAM wparam, LPARAM lparam)
{
  POINT pt;
  pt.x = GET_X_LPARAM(lparam);
  pt.y = GET_Y_LPARAM(lparam);

  if (GetCapture())
  {
    ReleaseCapture();
  }
}

void MAR_FoldersWnd::OnMouseMove(WPARAM wparam, LPARAM lparam)
{
  SetCursor(LoadCursor(NULL, IDC_IBEAM));

  if (GetCapture())
  {

  }
}

void MAR_FoldersWnd::OnTimer(WPARAM wparam, LPARAM lparam)
{
  if (wparam == MAR_FOLDERS_UPDATE_ID)
  {

  }
}

void MAR_FoldersWnd::OnKeyDown(WPARAM wparam, LPARAM lparam)
{
  //switch (wparam)
  //{}
}

INT_PTR MAR_FoldersWnd::OnNotify(WPARAM wparam, LPARAM lparam)
{
  switch (LOWORD(wparam))
  {
  case IDC_TREE1:
    {
      switch (((LPNMHDR)lparam)->code)
      {
      case TVN_SELCHANGED:
        {

        } break;
      case NM_DBLCLK:
        {
          HTREEITEM nit = TreeView_GetNextItem(((LPNMHDR)lparam)->hwndFrom, 0, TVGN_DROPHILITE);
          if (nit) TreeView_SelectItem(((LPNMHDR)lparam)->hwndFrom, nit);

          HTREEITEM it = TreeView_GetSelection(m_tree);
          if (it)
          {
            char text[2048];
            TVITEM tvi;
            tvi.hItem = it;
            tvi.mask = TVIF_TEXT|TVIF_PARAM;
            tvi.pszText = (char *)text;
            tvi.cchTextMax = (int)sizeof(text);
            if (TreeView_GetItem(m_tree, &tvi))
            {
              if (!strcmp((const char *)tvi.lParam, "file"))
              {
                if (g_volissos) g_volissos->Open(text);
              }
            }
          }
        } break;
      }
    }
    break;
  }

  return 0;
}

WDL_DLGRET MAR_FoldersWnd::FoldersWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  MAR_FoldersWnd *self = (MAR_FoldersWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (MAR_FoldersWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->FoldersWndLoop(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET MAR_FoldersWnd::FoldersWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_CLOSE: return OnClose(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_SYSCOMMAND: OnSysCommand(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
    case WM_PAINT: OnPaint(wparam, lparam); break;
    case WM_LBUTTONDOWN: OnLButtonDown(wparam, lparam); break;
    case WM_LBUTTONUP: OnLButtonUp(wparam, lparam); break;
    case WM_MOUSEMOVE: OnMouseMove(wparam, lparam); break;
    case WM_TIMER: OnTimer(wparam, lparam); break;
    case WM_KEYDOWN: OnKeyDown(wparam, lparam); break;
    case WM_NOTIFY: OnNotify(wparam, lparam); break;
  }

  return 0;
}
