// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_FOLDERS_WND_H_
#define _MARKELLA_FOLDERS_WND_H_

#include "definitions.h"
#include "main_wnd.h"

#include <WDL/wingui/wndsize.h>

class MAR_FoldersWnd
{
public:
  MAR_FoldersWnd();
  ~MAR_FoldersWnd();

  HWND Handle() const;
  void Search(const char *text);
  void RemoveSelection();
  void RemoveAll();

  static WDL_DLGRET FoldersWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnKeyDown(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  void DoPaint(HDC dc);
  WDL_DLGRET FoldersWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  HWND m_edit;
  HWND m_tree;
  TV_INSERTSTRUCT m_tvinsert;
  WDL_WndSizer m_resize;
};

#endif // _MARKELLA_FOLDERS_WND_H_
