// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MAR_GAP_H_
#define _MAR_GAP_H_

#include "gap_string.h"

class MAR_Gap
{
public:
  MAR_Gap();
  ~MAR_Gap();

  int GetSize() const;
  int GetLength() const;
  int GetPosition() const;

  void Attach(MAR_GapString *strbuf);
  void Insert(const char *str, int position, int maxlen);
  void Delete(int len);
  int Flush(int position);
  bool IsFlushed() const;

private:
  void New(int position);
  const int m_size;
  int m_startpos;
  int m_endpos;
  bool m_flushed;

  MAR_GapString *m_strbuf;
};

#endif //_MAR_GAP_H_
