/*
  gap_string.h derived from WDL - wdlstring.h
  Copyright (C) 2005 and later, Cockos Incorporated
  Modifications copyright (c) 2023, Giorgos Vougioukas

  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
      claim that you wrote the original software. If you use this software
      in a product, an acknowledgment in the product documentation would be
      appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not be
      misrepresented as being the original software.
  3. This notice may not be removed or altered from any source distribution.
*/

/*
  MAR_GapString: Feb 17, 2024
  ===========================
  * Use WDL_FastString implementation.

  MAR_GapString: Dec 17, 2023
  ===========================
  * Rename WDL_String to MAR_GapString.
  * Remove all file related operations.
  * Split file to .h and .cpp
  * Remove WDL_STRING_IMPL_ONLY
  * Remove WDL_STRING_FASTSUB_DEFINED
*/

#ifndef _MAR_GAP_STRING_H_
#define _MAR_GAP_STRING_H_

#include <WDL/heapbuf.h>

class MAR_GapString
{
public:
  explicit MAR_GapString(int hbgran);
  explicit MAR_GapString(const char *initial = NULL, int initial_len = 0);

  MAR_GapString(const MAR_GapString &s);
  MAR_GapString(const MAR_GapString *s);
  ~MAR_GapString();

  char *Get();
  const char *Get() const;
  int GetLength() const;

  // for binary-safe manipulations
  void SetRaw(const char *str, int len);
  void AppendRaw(const char *str, int len);
  void InsertRaw(const char *str, int position, int ilen);

  void Set(const char *str, int maxlen = 0);
  void Set(const MAR_GapString *str, int maxlen = 0);
  void Append(const char *str, int maxlen = 0);
  void Append(const MAR_GapString *str, int maxlen = 0);
  void DeleteSub(int position, int len);
  void Insert(const char *str, int position, int maxlen = 0);
  void Insert(const MAR_GapString *str, int position, int maxlen = 0);
  bool SetLen(int length, bool resizeDown = false, char fillchar = ' ');
  void SetAppendFormattedArgs(bool append, int maxlen, const char* fmt, va_list arglist);
  void WDL_VARARG_WARN(printf,3,4) SetFormatted(int maxlen, const char *fmt, ...);
  void WDL_VARARG_WARN(printf,3,4) AppendFormatted(int maxlen, const char *fmt, ...);
  void Ellipsize(int minlen, int maxlen);

private:
  void __doSet(int offs, const char *str, int len, int trailkeep);

  WDL_HeapBuf m_hb;
};

#endif //_MAR_GAP_STRING_H_
