// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "keymap.h"
#include "definitions.h"
#include "main_wnd.h"
#include "volissos.h"
#include "surface_wnd.h"

#include <WDL/aggarray.h>

// Virtual key

static void Internal_HelpAbout()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_ABOUT, 0);
}

static void Internal_HelpChangelog()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_CHANGELOG, 0);
}

static void Internal_HelpVersion()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_VERSION, 0);
}

static void Internal_ToggleFullscreen()
{
  g_mainwnd->ToggleFullscreen();
}

// Normal key

static void Internal_NewProject()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_NEW_PROJECT, 0);
}

static void Internal_OpenProject()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_OPEN_PROJECT, 0);
}

static void Internal_OpenDirectoryProject()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_OPENFOLDER_PROJECT, 0);
}

static void Internal_ProjectSave()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_SAVE_PROJECT, 0);
}

static void Internal_ProjectSaveAs()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_SAVEAS_PROJECT, 0);
}

static void Internal_ProjectSaveAll()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_SAVEALL_PROJECT, 0);
}

static void Internal_Preferences()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
}

static void Internal_ExitMarkella()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EXIT, 0);
}

static void Internal_ShowProjects()
{
  if (g_mainwnd) g_mainwnd->ShowProjects();
}

static void Internal_ToggleLineNumber()
{
  if (g_mainwnd) g_mainwnd->ToggleLineNumber();
}

static void Internal_ToggleHideFileName()
{
  if (g_mainwnd) g_mainwnd->ToggleFileName();
}

static void Internal_FindKeyWord()
{
  if (g_mainwnd) g_mainwnd->FindKeyWord();
}

static void Internal_ChangeKeyWord()
{
  if (g_mainwnd) g_mainwnd->ChangeKeyWord();
}

static void Internal_GoToLine()
{
  if (g_mainwnd) g_mainwnd->GoToLine();
}

static void Internal_CutText()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->Cut();
  }
}

static void Internal_CopyText()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->Copy();
  }
}

static void Internal_PasteText()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->Paste();
  }
}

static void Internal_SelectAll()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SelectAll();
  }
}

static void Internal_Close()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_CLOSEFILE, 0);
}

static void Internal_CloseTheRest()
{
  SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_CLOSETHEREST, 0);
}

static void Internal_ToggleRuler()
{
  if (g_mainwnd) g_mainwnd->ToggleRuler();
}

static void Internal_ToggleWhitespace()
{
  if (g_mainwnd) g_mainwnd->ToggleWhitespace();
}

static void Internal_CommentLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->CommentLine();
  }
}

static void Internal_UncommentLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->UncommentLine();
  }
}

static void Internal_FindNextKeyWord()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->FindNextKeyWord();
  }
}

static void Internal_FindPreviousKeyWord()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->FindPreviousKeyWord();
  }
}

static void Internal_OpenPreviousFile()
{
  if (g_mainwnd) g_mainwnd->SwitchToPreviousFile();
}

static void Internal_ReopenFile()
{
  if (g_mainwnd) g_mainwnd->ReopenFile();
}

static void Internal_MoveCursorLeft()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionPreviousChar(false);
  }
}

static void Internal_MoveCursorRight()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionNextChar(false);
  }
}

static void Internal_MoveCursorWordLeft()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionPreviousWord(false);
  }
}

static void Internal_MoveCursorWordRight()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionNextWord(false);
  }
}

static void Internal_MoveCursorStartOfFile()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionStartOfFile(false);
  }
}

static void Internal_MoveCursorEndOfFile()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionEndOfFile(false);
  }
}

static void Internal_MoveCursorStartOfLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionStartOfLine(false);
  }
}

static void Internal_MoveCursorEndOfLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionEndOfLine(false);
  }
}

static void Internal_MoveCursorPreviousLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionPreviousLine(false);
  }
}

static void Internal_MoveCursorNextLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionNextLine(false);
  }
}

static void Internal_MovePageOneLineUp()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    if (g_surfacewnd)
    {
      (g_surfacewnd->SetPageOneLineUp());
    }
  }
}

static void Internal_MovePageOneLineDown()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    if (g_surfacewnd)
    {
      (g_surfacewnd->SetPageOneLineDown());
    }
  }
}

static void Internal_MoveCursorPageUp()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    if (g_surfacewnd)
    {
      gb->SetPositionPageUp(g_surfacewnd->GetLines(), false);
    }
  }
}

static void Internal_MoveCursorPageDown()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    if (g_surfacewnd)
    {
      gb->SetPositionPageDown(g_surfacewnd->GetLines(), false);
    }
  }
}

static void Internal_SelectCursorLeft()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionPreviousChar(true);
  }
}

static void Internal_SelectCursorRight()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionNextChar(true);
  }
}

static void Internal_SelectCursorWordLeft()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionPreviousWord(true);
  }
}

static void Internal_SelectCursorWordRight()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionNextWord(true);
  }
}

static void Internal_SelectCursorStartOfFile()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionStartOfFile(true);
  }
}

static void Internal_SelectCursorEndOfFile()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionEndOfFile(true);
  }
}

static void Internal_SelectCursorStartOfLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionStartOfLine(true);
  }
}

static void Internal_SelectCursorEndOfLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionEndOfLine(true);
  }
}

static void Internal_SelectCursorPreviousLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionPreviousLine(true);
  }
}

static void Internal_SelectCursorNextLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->SetPositionNextLine(true);
  }
}

static void Internal_SelectCursorPageUp()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    if (g_surfacewnd)
    {
      gb->SetPositionPageUp(g_surfacewnd->GetLines(), true);
    }
  }
}

static void Internal_SelectCursorPageDown()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    if (g_surfacewnd)
    {
      gb->SetPositionPageDown(g_surfacewnd->GetLines(), true);
    }
  }
}

static void Internal_ToggleInsert()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->ToggleInsert();
  }
}

static void Internal_DeleteForward()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->DeleteText(1, true);

    if (g_surfacewnd) g_surfacewnd->RequestRedraw();
  }
}

static void Internal_DeleteWordForward()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->DeleteWord(true);

    if (g_surfacewnd) g_surfacewnd->RequestRedraw();
  }
}

static void Internal_DeleteBackward()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->DeleteText(1, false);
  }
}

static void Internal_DeleteWordBackward()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->DeleteWord(false);
  }
}

static void Internal_NewLine()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->InsertText("\n", 1);
  }
}

static void Internal_InsertTab()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->InsertTab();
  }
}

static void Internal_RemoveTab()
{
  MAR_GapBuffer *gb = g_volissos->GetGapBuffer();
  if (gb)
  {
    gb->RemoveTab();
  }
}

static void Internal_ShowSwitch()
{
  if (g_mainwnd) g_mainwnd->ShowSwitch();
}

// VK_OEM_1: semicolon (0xBA)
// VK_OEM_2: slash (0xBF)
// VK_OEM_3: tilde (0xC0)
// VK_OEM_4: left bracket (0xDB)
// VK_OEM_5: backslash (0xDC)
// VK_OEM_6: right bracket (0xDD)
// VK_OEM_7: quote (0xDE)
// VK_OEM_PLUS: equal (0xBB)
// VK_OEM_MINUS: dash (0xBD)
// VK_OEM_COMMA: comma (0xBC)
// VK_OEM_PERIOD: period (0xBE)

static MAR_HotKey internal_hotkeydown[] =
{
  // virkey, key, ctrl, menu, shift, action
  { true, VK_F1, true, false, false, &Internal_HelpAbout },
  { true, VK_F2, true, false, false, &Internal_HelpChangelog },
  { true, VK_F3, true, false, false, &Internal_HelpVersion },
  { true, VK_F11, false, false, false, &Internal_ToggleFullscreen },
  { false, 'N', true, false, false, &Internal_NewProject },
  { false, 'O', true, false, false, &Internal_OpenProject },
  { false, 'O', true, false, true, &Internal_OpenDirectoryProject },
  { false, 'S', true, false, false, &Internal_ProjectSave },
  { false, 'S', false, true, false, &Internal_ProjectSaveAs },
  { false, 'S', true, false, true, &Internal_ProjectSaveAll },
  { false, 'P', true, false, false, &Internal_Preferences },
  { false, 'Q', true, false, false, &Internal_ExitMarkella },
  { false, 'D', false, true, false, &Internal_ShowProjects },
  { false, 'L', true, false, false, &Internal_ToggleLineNumber },
  { false, 'T', true, false, false, &Internal_ToggleHideFileName },
  { false, 'F', true, false, false, &Internal_FindKeyWord },
  { false, 'H', true, false, false, &Internal_ChangeKeyWord },
  { false, 'G', true, false, false, &Internal_GoToLine },
  { false, 'X', true, false, false, &Internal_CutText },
  { false, 'C', true, false, false, &Internal_CopyText },
  { false, 'V', true, false, false, &Internal_PasteText },
  { false, 'A', true, false, false, &Internal_SelectAll },
  { false, 'W', true, false, false, &Internal_Close },
  { false, 'W', true, false, true, &Internal_CloseTheRest },
  { false, 'R', true, false, false, &Internal_ToggleRuler },
  { false, 'D', true, false, false, &Internal_ToggleWhitespace },
  { false, 'K', true, false, false, &Internal_CommentLine },
  { false, 'U', true, false, false, &Internal_UncommentLine },
  { true, VK_F3, false, false, false, &Internal_FindNextKeyWord },
  { true, VK_F3, false, false, true, &Internal_FindPreviousKeyWord },
  { true, VK_F2, false, false, false, &Internal_OpenPreviousFile },
  { true, VK_F5, false, false, false, &Internal_ReopenFile },

  { true, VK_LEFT, false, false, false, &Internal_MoveCursorLeft },
  { true, VK_RIGHT, false, false, false, &Internal_MoveCursorRight },
  { true, VK_LEFT, true, false, false, &Internal_MoveCursorWordLeft },
  { true, VK_RIGHT, true, false, false, &Internal_MoveCursorWordRight },
  { true, VK_HOME, true, false, false, &Internal_MoveCursorStartOfFile },
  { true, VK_END, true, false, false, &Internal_MoveCursorEndOfFile },
  { true, VK_HOME, false, false, false, &Internal_MoveCursorStartOfLine },
  { true, VK_END, false, false, false, &Internal_MoveCursorEndOfLine },
  { true, VK_UP, false, false, false, &Internal_MoveCursorPreviousLine },
  { true, VK_DOWN, false, false, false, &Internal_MoveCursorNextLine },
  { true, VK_UP, true, false, false, &Internal_MovePageOneLineUp },
  { true, VK_DOWN, true, false, false, &Internal_MovePageOneLineDown },
  { true, VK_PRIOR, false, false, false, &Internal_MoveCursorPageUp },
  { true, VK_NEXT, false, false, false, &Internal_MoveCursorPageDown },
  { true, VK_LEFT, false, false, true, &Internal_SelectCursorLeft },
  { true, VK_RIGHT, false, false, true, &Internal_SelectCursorRight },
  { true, VK_LEFT, true, false, true, &Internal_SelectCursorWordLeft },
  { true, VK_RIGHT, true, false, true, &Internal_SelectCursorWordRight },
  { true, VK_HOME, true, false, true, &Internal_SelectCursorStartOfFile },
  { true, VK_END, true, false, true, &Internal_SelectCursorEndOfFile },
  { true, VK_HOME, false, false, true, &Internal_SelectCursorStartOfLine },
  { true, VK_END, false, false, true, &Internal_SelectCursorEndOfLine },
  { true, VK_UP, false, false, true, &Internal_SelectCursorPreviousLine },
  { true, VK_DOWN, false, false, true, &Internal_SelectCursorNextLine },
  { true, VK_PRIOR, false, false, true, &Internal_SelectCursorPageUp },
  { true, VK_NEXT, false, false, true, &Internal_SelectCursorPageDown },

  { true, VK_INSERT, false, false, false, &Internal_ToggleInsert },
  { true, VK_DELETE, false, false, false, &Internal_DeleteForward },
  { true, VK_DELETE, true, false, false, &Internal_DeleteWordForward },
  { true, VK_BACK, false, false, false, &Internal_DeleteBackward },
  { true, VK_BACK, true, false, false, &Internal_DeleteWordBackward },
  { true, VK_RETURN, false, false, false, &Internal_NewLine },
  { true, VK_TAB, false, false, false, &Internal_InsertTab },
  { true, VK_TAB, false, false, true, &Internal_RemoveTab },
  { true, VK_TAB, true, false, false, &Internal_ShowSwitch }
};

static WDL_PtrArray<MAR_HotKey, WDL_ARRAYCOUNT(internal_hotkeydown)> internal_hkdown(internal_hotkeydown);

static MAR_HotKey internal_hotkeyup[] =
{
  // virkey, key, ctrl, menu, shift, action
  {}
};

static WDL_PtrArray<MAR_HotKey, WDL_ARRAYCOUNT(internal_hotkeyup)> internal_hkup(internal_hotkeyup);

MAR_KeyMap::MAR_KeyMap()
{
  for (int i = 0; i < internal_hkdown.GetSize(); i++)
  {
    m_hotkeydown.Add(internal_hkdown.Get()[i]);
  }

  for (int i = 0; i < internal_hkup.GetSize(); i++)
  {
    m_hotkeyup.Add(internal_hkup.Get()[i]);
  }
}

MAR_KeyMap::~MAR_KeyMap()
{}

int MAR_KeyMap::GetHotKeyDownSize() const
{
  return m_hotkeydown.GetSize();
}

MAR_HotKey *MAR_KeyMap::GetHotKeyDown() const
{
  return m_hotkeydown.Get();
}

int MAR_KeyMap::GetHotKeyUpSize() const
{
  return m_hotkeyup.GetSize();
}

MAR_HotKey *MAR_KeyMap::GetHotKeyUp() const
{
  return m_hotkeyup.Get();
}
