// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_LINE_WND_H_
#define _MARKELLA_LINE_WND_H_

#include "definitions.h"

#include <WDL/ptrlist.h>
#include <WDL/wdlstring.h>
#include <WDL/wingui/wndsize.h>
#include <WDL/wingui/virtwnd.h>
#include <WDL/lice/lice.h>
#include <WDL/lice/lice_text.h>

class MAR_LineWnd
{
public:
  explicit MAR_LineWnd(HWND hwnd);
  ~MAR_LineWnd();

  HWND Handle() const { return m_hwnd; }
  void Start(int line_start, int lines, int current_line, int column);
  int GetMaximumWidth() const;

  static WDL_DLGRET LineWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnKeyDown(WPARAM wparam, LPARAM lparam);
  void DoPaint(HDC dc);
  WDL_DLGRET LineWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewLineWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;

  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  WDL_FastString m_strbuf;
  int m_letterwidth;
  int m_letterheight;
  int m_textheight;
  int m_top;
  int m_bottom;
  WDL_PtrList<WDL_FastString> m_lines;
  WDL_PtrList<WDL_FastString> m_linesempty;
  int m_curline;
  int m_maxwidth;
  const int m_startspace;
};

#endif // _MARKELLA_LINE_WND_H_
