// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_PREFERENCES_H_
#define _MARKELLA_PREFERENCES_H_

#include <string.h>
#include <stdlib.h>

#include <third_party/cJSON/cJSON.h>

#include <WDL/wdlstring.h>

class MAR_Preferences
{
public:
  MAR_Preferences();
  ~MAR_Preferences();

  void Create();
  void Open(bool default_file = false);

  bool Parse(bool default_file = false);
  const char *GetParseError() const { return m_err.Get(); }

  void SetRelaunch(bool enable) { m_relaunch = enable; }
  bool WantRelaunch() const { return m_relaunch; }

  bool WantCursesRightFocus() const;
  int GetTabSize() const;
  bool WantSpaces() const;
  int EndOfLine() const;
  bool WantPreserveDirectory() const;
  int GetRuler() const;
  bool WantAncientWisdom() const;

private:
  cJSON *m_pf;
  WDL_FastString m_err;
  bool m_relaunch;
};

#endif // _MARKELLA_PREFERENCES_H_
