// Copyright (c) 2024 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_SCAN_FILES_H_
#define _MARKELLA_SCAN_FILES_H_

#include "definitions.h"

#include <WDL/mutex.h>
#include <WDL/ptrlist.h>
#include <WDL/wdlstring.h>
#include <WDL/lineparse.h>

class MAR_ScanFiles
{
public:
  MAR_ScanFiles();
  ~MAR_ScanFiles();

  void Open(const char *path);
  bool IsScanning() const;
  const char *GetPath() const;

  WDL_PtrList<WDL_FastString> files;

private:
  void Scan(const char *path, bool empty_buffer = true);
  void StartThread();
  void StopThread();
  bool IsRunning() const;
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  static int sort_by_file_path(const void *a, const void *b)
  {
    WDL_FastString *s1, *s2;
    s1 = *(WDL_FastString **)a;
    s2 = *(WDL_FastString **)b;
    return wdl_filename_cmp(s1->Get(), s2->Get());
  }

  unsigned int m_threadid;
  HANDLE m_threadhandle;
  bool m_killthread;
  WDL_Mutex m_mutex;
  bool m_running;

  bool m_cancel;
  LineParser m_lp;
  WDL_FastString m_path;
  bool m_scan;
};

#endif // _MARKELLA_SCAN_FILES_H_
