// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_SURFACE_WND_H_
#define _MARKELLA_SURFACE_WND_H_

#include "definitions.h"

#include <WDL/wdlstring.h>
#include <WDL/wingui/wndsize.h>
#include <WDL/wingui/virtwnd.h>
#include <WDL/lice/lice.h>
#include <WDL/lice/lice_text.h>

struct MAR_SurfaceContext
{
  MAR_SurfaceContext()
    : viewcursor(false)
    , blinkrate(0)
    , minsurfacelines(0)
    , lines(0)
    , columns(0)
    , lastline(0)
    , lastcolumn(0)
    , textheight(0)
    , cursorcolumn(0)
    , cursorline(0)
    , maxline(0)
    , fulldraw(true)
    , letterheight(0)
    , letterwidth(0)
    , scrolloffset(0)
    , lastoffset(0)
    , cursornoblink(false)
    , startspace(5)
    , xoffset(0)
    , yoffset(0)
    , top(0)
    , bottom(0)
    , mouseln(0)
    , mousecol(0)
    , selection(false)
  {
    vsi.cbSize = 0;
  }
  bool viewcursor;
  int blinkrate;
  int minsurfacelines;
  int lines;
  int columns;
  int lastline;
  int lastcolumn;
  int textheight;
  int cursorcolumn;
  int cursorline;
  int maxline;
  LICE_SysBitmap lastcursorbm;
  RECT lastcursor;
  bool fulldraw;
  int letterheight;
  int letterwidth;
  int scrolloffset;
  int lastoffset;
  bool cursornoblink;
  const int startspace;
  SCROLLINFO vsi;
  int xoffset;
  int yoffset;
  int top;
  int bottom;
  int mouseln;
  int mousecol;
  bool selection;
};

class MAR_SurfaceWnd
{
public:
  explicit MAR_SurfaceWnd(HWND hwnd);
  ~MAR_SurfaceWnd();

  HWND Handle() const;
  int GetLines() const;
  void RequestRedraw();
  void SetPageOneLineUp();
  void SetPageOneLineDown();
  void FindKeyWord(const char *find, bool case_sensitive, bool match_whole_word);
  void ChangeKeyWord(const char *find, const char *change, bool case_sensitive, bool match_whole_word);
  void ToggleRuler();
  bool HasRuler() const;
  void ToggleWhitespace();
  bool HasWhitespace() const;

  static WDL_DLGRET SurfaceWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnVScroll(WPARAM wparam, LPARAM lparam);
  void OnKeyDown(WPARAM wparam, LPARAM lparam);
  void OnMouseWheel(WPARAM wparam, LPARAM lparam);
  void DoPaint(HDC dc);
  WDL_DLGRET SurfaceWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewSurfaceWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  WDL_FastString m_strbuf;
  WDL_FastString m_prevfn;
  MAR_SurfaceContext *m_ctx;
  int m_ruler;
  bool m_lazy;
  bool m_whitespace;
  bool m_onepingonly;
  int m_maxim;
};

#endif // _MARKELLA_SURFACE_WND_H_
