// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MARKELLA_VOLISSOS_H_
#define _MARKELLA_VOLISSOS_H_

#include "definitions.h"
#include "gap_buffer.h"

#include <WDL/mutex.h>
#include <WDL/wdlstring.h>
#include <WDL/assocarray.h>

class MAR_Volissos
{
public:
  MAR_Volissos();
  ~MAR_Volissos();

  void New();
  bool Open(const char *filename);
  void Reopen();
  bool IsOpen() const;
  void SwitchToPrevious();
  bool HasPrevious() const;
  void Close();
  void CloseTheRest();
  void ActiveFile(const char *filename);
  void RenameFile(const char *old_filename,
    const char *new_filename);

  void InsertText(const char *text, int length);
  void DeleteText(int length, bool forward);

  MAR_GapBuffer *GetGapBuffer() const;
  MAR_GapBuffer *GetGapBuffer(int index) const;
  int GetGapBufferSize() const;

private:
  void SetPrevious();
  void StartThread();
  void StopThread();
  bool IsRunning() const;
  static unsigned int WINAPI ThreadFunction(void *arg);
  int Run();

  unsigned int m_threadid;
  HANDLE m_threadhandle;
  bool m_killthread;
  WDL_Mutex m_mutex;
  bool m_running;

  WDL_FastString m_activefile;
  WDL_FastString m_previousfile;
  WDL_StringKeyedArray<MAR_GapBuffer *> m_files;
  int m_original;
};

#endif // _MARKELLA_VOLISSOS_H_
