!include "MUI2.nsh"
!include "LogicLib.nsh"

;Unicode true

;SetCompress off
SetCompressor zlib
;SetCompressor /solid LZMA
;SetCompressorDictSize 8
;RequestExecutionLevel highest
RequestExecutionLevel admin

;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-install-alt.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-uninstall.ico"
;!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\nsis3-metro.bmp"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_COMPONENTSPAGE_NODESC
!define MUI_FINISHPAGE_NOAUTOCLOSE

!searchparse /file ..\src\mnemosyne\app_info.h '#define MNEMOSYNE_MAJOR_VERSION ' MAJOR
!searchparse /file ..\src\mnemosyne\app_info.h '#define MNEMOSYNE_MINOR_VERSION ' MINOR
!searchparse /file ..\src\mnemosyne\app_info.h '#define MNEMOSYNE_RELEASE "' RELEASE '"'
!searchparse /file ..\src\mnemosyne\app_info.h '#define MNEMOSYNE_COPYRIGHT "' COPYRIGHT '"'
!searchparse /file ..\src\mnemosyne\app_info.h '#define MNEMOSYNE_COMPANY_URL "' COMPANY '"'

Name "Mnemosyne"
OutFile "mnemosyne-${MAJOR}.${MINOR}${RELEASE}-x64-install.exe"
;BrandingText "Grafmin"

VIAddVersionKey "ProductName" "Mnemosyne"
VIAddVersionKey "CompanyName" "${COMPANY}"
VIAddVersionKey "FileDescription" "Mnemosyne installer (x64)"
VIAddVersionKey "FileVersion" "${MAJOR}.${MINOR}.0.0"
VIAddVersionKey "ProductVersion" "${MAJOR}.${MINOR}"
VIAddVersionKey "LegalCopyright" "${COPYRIGHT}"
VIProductVersion "${MAJOR}.${MINOR}.0.0"

InstallDir "$PROGRAMFILES64\Mnemosyne"

;Get installation folder from registry if available
InstallDirRegKey HKCU "Software\Mnemosyne (x64)" ""

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN $INSTDIR\mnemosyne.exe

!insertmacro MUI_PAGE_LICENSE "..\doc\license.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
;AutoCloseWindow true

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Section "Mnemosyne" SecMnemosyne
  SectionIn RO

  SetOutPath "$INSTDIR"

  File "..\build\vc\x64\Release\mnemosyne.exe"
  File "..\build\vc\x64\Release\changelog.txt"
  File "..\build\vc\x64\Release\license.txt"
  File "..\build\vc\Win32\Release\documentation.txt"

  ;Store installation folder
  WriteRegStr HKCU "Software\Mnemosyne (x64)" "" $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\uninstall.exe"
SectionEnd

Section "Start menu shortcuts" SecStart
  SetOutPath "$SMPROGRAMS\Mnemosyne (x64)"
  CreateShortcut "$OUTDIR\Mnemosyne (x64).lnk" "$INSTDIR\mnemosyne.exe"
  CreateShortcut "$OUTDIR\Uninstall Mnemosyne (x64).lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section /o "Desktop icon" SecDesktop
  SetOutPath $DESKTOP
  CreateShortcut "$OUTDIR\Mnemosyne (x64).lnk" "$INSTDIR\mnemosyne.exe"
SectionEnd

;Language strings
LangString DESC_SecMnemosyne ${LANG_ENGLISH} "Mnemosyne core (required)."
LangString DESC_SecStart ${LANG_ENGLISH} "Start menu shortcuts."
LangString DESC_SecDesktop ${LANG_ENGLISH} "Desktop icon."

;Assign language strings to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecMnemosyne} $(DESC_SecMnemosyne)
!insertmacro MUI_DESCRIPTION_TEXT ${SecStart} $(DESC_SecStart)
!insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  StrCpy $1 "mnemosyne.exe"

retry:
  nsProcess::_FindProcess "$1"

  Pop $R0
  ${if} $R0 = 0
    MessageBox MB_RETRYCANCEL "Mnemosyne is running. Close Mnemosyne and hit Retry." /SD IDRETRY IDCANCEL cancel
    Goto retry
  ${endif}

  Delete "$DESKTOP\Mnemosyne (x64).lnk"
  Delete "$SMPROGRAMS\Mnemosyne (x64)\Mnemosyne (x64).lnk"
  Delete "$SMPROGRAMS\Mnemosyne (x64)\Uninstall Mnemosyne (x64).lnk"
  RMDir /r "$SMPROGRAMS\Mnemosyne (x64)"

  Delete "$INSTDIR\mnemosyne.exe"
  Delete "$INSTDIR\changelog.txt"
  Delete "$INSTDIR\license.txt"
  Delete "$INSTDIR\documentation.txt"
  Delete "$INSTDIR\uninstall.exe"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\Mnemosyne (x64)"

  Goto cont

cancel:
  Abort

cont:
SectionEnd
