// Based on chromium implementation:
//
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license.

#ifndef _WDL_ALIGNMEM_H_
#define _WDL_ALIGNMEM_H_

#include <stddef.h>
#include <stdint.h>

#if defined(_WIN32)
#include <malloc.h>
#else
#include <stdlib.h>
#endif

#include <WDL/wdltypes.h>

inline void *wdl_aligned_alloc(size_t size, size_t alignment)
{
  void *ptr = NULL;
#if defined(_WIN32)
  ptr = _aligned_malloc(size, alignment);
#else
  if (posix_memalign(&ptr, alignment, size))
  {
    ptr = NULL;
  }
#endif

  if (WDL_NOT_NORMALLY(!ptr))
  {
    return NULL;
  }

  return ptr;
}

inline void wdl_aligned_free(void *ptr)
{
#if defined(_WIN32)
  _aligned_free(ptr);
#else
  free(ptr);
#endif
}

#endif // _WDL_ALIGNMEM_H_
