rem Cleanup
rem =======

rem del *.zip
rem del changelog.txt

copy ..\doc\changelog.txt .\

rem Mnemosyne x86 (installer)
rem =========================

makensis mnemosyne_x86.nsi

rem Mnemosyne x64 (installer)
rem =========================

makensis mnemosyne_x64.nsi

rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define MNEMOSYNE_MAJOR_VERSION " ..\src\mnemosyne\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~33,1%

for /f "delims=" %%a in ('findstr /b /c:"#define MNEMOSYNE_MINOR_VERSION " ..\src\mnemosyne\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~33,2%

for /f "delims=" %%a in ('findstr /b /c:"#define MNEMOSYNE_RELEASE " ..\src\mnemosyne\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~28%

rem Mnemosyne x86 (portable)
rem ========================

rem Note: -mx=1 (fastest), -mx=3 (fast), nothing or -mx=5 (normal)

7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\mnemosyne.exe
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\changelog.txt
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\license.txt
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\documentation.txt
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x86.zip portable
7z d -r mnemosyne-%maj%.%min%%rel%-x86.zip *.lib
7z d -r mnemosyne-%maj%.%min%%rel%-x86.zip *.pdb
7z d -r mnemosyne-%maj%.%min%%rel%-x86.zip *.exp
7z t mnemosyne-%maj%.%min%%rel%-x86.zip * -r

rem Mnemosyne x64 (portable)
rem ========================

7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\mnemosyne.exe
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\changelog.txt
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\license.txt
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\documentation.txt
7z a -tzip -mx=1 mnemosyne-%maj%.%min%%rel%-x64.zip portable
7z d -r mnemosyne-%maj%.%min%%rel%-x64.zip *.lib
7z d -r mnemosyne-%maj%.%min%%rel%-x64.zip *.pdb
7z d -r mnemosyne-%maj%.%min%%rel%-x64.zip *.exp
7z t mnemosyne-%maj%.%min%%rel%-x64.zip * -r

cd ..
git archive --format=zip --prefix=GV-191/ HEAD > pack\mnemosyne-%maj%.%min%%rel%-src.zip
git archive --format=tar.gz --prefix=GV-191/ HEAD > pack\mnemosyne-%maj%.%min%%rel%-src.tar.gz

pause
