// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MNEMOSYNE_ABOUT_WND_H_
#define _MNEMOSYNE_ABOUT_WND_H_

#include "mnemosyne/definitions.h"
#include "mnemosyne/app_info.h"

#include <string.h>
#include <stdlib.h>

#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"

class RSM_AboutWnd
{
public:
  RSM_AboutWnd()
    : m_hwnd(NULL)
    , m_x(0)
    , m_y(0)
    , m_w(0)
    , m_h(0)
    , m_bm(NULL)
    , m_font(NULL)
    , m_font_alpha(255)
    , m_scroll_offset_y(0)
    , m_credits_height(0)
    , m_calc(true)
  {}

  ~RSM_AboutWnd()
  {
    DestroyWindow(m_hwnd);
    delete m_bm;
    delete m_font;
  }

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET AboutWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog();
  void OnPaint();
  void OnTimer();
  void OnSize();
  void OnDestroy();
  void OnCommand();
  void DoPaint(HDC dc);
  int Run();
  WDL_DLGRET AboutWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;

  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  int m_font_alpha;
  int m_scroll_offset_y;
  int m_credits_height;
  bool m_calc;
  WDL_TypedBuf<int> m_disjunction;
};

#endif // _MNEMOSYNE_ABOUT_WND_H_
