// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MNEMOSYNE_INFO_H_
#define _MNEMOSYNE_INFO_H_

#include <string.h>

#include "mnemosyne/git_sha1.h"

#define MNEMOSYNE_MAJOR_VERSION 1
#define MNEMOSYNE_MINOR_VERSION 10

#define MNEMOSYNE_RELEASE ""
#define MNEMOSYNE_SPECIAL ""

#define MNEMOSYNE_NAME "mnemosyne"
#define MNEMOSYNE_NAME_MARKETING "Mnemosyne"
#define MNEMOSYNE_COMPANY_URL "https://www.grafmin.gr/"
#define MNEMOSYNE_WEBSITE_URL "https://www.grafmin.gr/mnemosyne"
#define MNEMOSYNE_COPYRIGHT "Copyright (c) 2022-2025 Giorgos Vougioukas"

#define MNEMOSYNE_STRINGIFY_HELPER(x) #x
#define MNEMOSYNE_STRINGIFY(x) MNEMOSYNE_STRINGIFY_HELPER(x)

#define MNEMOSYNE_NAKED_VERSION \
  MNEMOSYNE_STRINGIFY(MNEMOSYNE_MAJOR_VERSION) \
  "." MNEMOSYNE_STRINGIFY(MNEMOSYNE_MINOR_VERSION) \
  MNEMOSYNE_RELEASE MNEMOSYNE_SPECIAL

#define MNEMOSYNE_FULL_VERSION \
  MNEMOSYNE_NAME_MARKETING " " MNEMOSYNE_NAKED_VERSION

#define MNEMOSYNE_GIT_SHA MNEMOSYNE_STRINGIFY(GIT_SHA1)

#define MNEMOSYNE_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(MNEMOSYNE_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define MNEMOSYNE_ARCH "x64"
  #elif defined(_M_IX86)
    #define MNEMOSYNE_ARCH "x86"
  #else
    #define MNEMOSYNE_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define MNEMOSYNE_ARCH "amd64"
  #elif defined(__i386__)
    #define MNEMOSYNE_ARCH "i686"
  #else
    #define MNEMOSYNE_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define MNEMOSYNE_ARCH "x86-64"
  #elif defined(__i386__)
    #define MNEMOSYNE_ARCH "i386"
  #else
    #define MNEMOSYNE_ARCH "unk"
  #endif
#endif

#endif // _MNEMOSYNE_INFO_H_
