// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "mnemosyne/changelog_wnd.h"

#define RSM_CHANGELOG_UPDATE_ID 331
#define RSM_CHANGELOG_UPDATE_MS 50

static win32CursesCtx s_curses_ctx;

RSM_ChangelogWnd::RSM_ChangelogWnd()
  : m_hwnd(NULL)
  , m_preview(&s_curses_ctx)
{}

RSM_ChangelogWnd::~RSM_ChangelogWnd()
{
  DestroyWindow(m_hwnd);
}

void RSM_ChangelogWnd::OnInitDialog()
{
  HWND cc = GetDlgItem(m_hwnd, IDC_CUSTOM1);
  curses_setWindowContext(cc, &s_curses_ctx);

  m_resize.init(m_hwnd);
  m_resize.init_itemhwnd(cc, 0.0f, 0.0f, 1.0f, 1.0f);

  int x = GetPrivateProfileInt(MNEMOSYNE_NAME, "changelog_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(MNEMOSYNE_NAME, "changelog_wnd_y", 50, g_inipath.Get());
  SetWindowPos(m_hwnd, NULL, x, y, 620, 505, SWP_NOZORDER | SWP_NOACTIVATE);

  WDL_FastString changelog;
  changelog.Set(g_modpath.Get());
  changelog.Append("changelog.txt");

  m_preview.SetParent(m_hwnd);
  m_preview.init(changelog.Get());
  m_preview.draw();
  m_preview.setCursor();

  SetFocus(cc);
  SetTimer(m_hwnd, RSM_CHANGELOG_UPDATE_ID, RSM_CHANGELOG_UPDATE_MS, NULL);
}

void RSM_ChangelogWnd::OnTimer()
{
  if (m_wparam == RSM_CHANGELOG_UPDATE_ID)
  {
    m_preview.RunEditor();
  }
}

void RSM_ChangelogWnd::OnDestroy()
{
  KillTimer(m_hwnd, RSM_CHANGELOG_UPDATE_ID);
  m_preview.ClearText();

  RECT r;
  GetWindowRect(m_hwnd, &r);

  WDL_FastString rleft, rtop;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);

  WritePrivateProfileString(MNEMOSYNE_NAME,"changelog_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(MNEMOSYNE_NAME,"changelog_wnd_y", rtop.Get(), g_inipath.Get());
}

void RSM_ChangelogWnd::OnSize()
{
  if (m_wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();
  }
}

void RSM_ChangelogWnd::OnCommand()
{
  switch(LOWORD(m_wparam))
  {
    case IDCANCEL:
    {
      if (g_changelogwnd) { delete g_changelogwnd; g_changelogwnd = NULL; }
    }
    break;
  }
}

void RSM_ChangelogWnd::OnSysCommand()
{
  if (LOWORD(m_wparam) == SC_CLOSE)
  {
    if (g_changelogwnd) { delete g_changelogwnd; g_changelogwnd = NULL; }
  }
}

WDL_DLGRET RSM_ChangelogWnd::ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RSM_ChangelogWnd *self = (RSM_ChangelogWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RSM_ChangelogWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->ChangelogWndLoop(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET RSM_ChangelogWnd::ChangelogWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  m_msg = msg;
  m_wparam = wparam;
  m_lparam = lparam;

  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(); break;
    case WM_TIMER: OnTimer(); break;
    case WM_DESTROY: OnDestroy(); break;
    case WM_SIZE: OnSize(); break;
    case WM_COMMAND: OnCommand(); break;
    case WM_SYSCOMMAND: OnSysCommand(); break;
  }

  return 0;
}
