// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _MNEMOSYNE_DEFINITIONS_H_
#define _MNEMOSYNE_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#include "mnemosyne/res/resource.h"

#include "WDL/wdltypes.h"
#include "WDL/win32_utf8.h"
#include "WDL/wdlstring.h"

class RSM_MainWnd;
class RSM_PictureWnd;
class RSM_AboutWnd;
class RSM_ChangelogWnd;
class RSM_LicenseWnd;

extern HINSTANCE g_inst;
extern UINT g_scrollmessage;

extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;

extern RSM_MainWnd *g_mainwnd;
extern RSM_PictureWnd *g_picwnd;
extern RSM_AboutWnd *g_aboutwnd;
extern RSM_ChangelogWnd *g_changelogwnd;
extern RSM_LicenseWnd *g_licwnd;

extern void RSM_RunMessageLoop();
extern int RSM_ProcessMessage(MSG *msg);

#endif // _MNEMOSYNE_DEFINITIONS_H_
