// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "mnemosyne/definitions.h"
#include "mnemosyne/main_wnd.h"
#include "mnemosyne/picture_wnd.h"
#include "mnemosyne/about_wnd.h"
#include "mnemosyne/changelog_wnd.h"
#include "mnemosyne/license_wnd.h"

int RSM_ProcessMessage(MSG *msg)
{
  if (msg->hwnd == g_mainwnd->Handle() || IsChild(g_mainwnd->Handle(), msg->hwnd))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
          msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd->Handle())
      {
        //InvalidateRect(g_mainwnd->Handle(), NULL, FALSE);
      }
    }

    //if (msg->message == WM_MOUSEWHEEL)
    //{
    //  SendMessage(msg->hwnd, WM_MOUSEWHEEL, msg->wParam, msg->lParam);

    //  return 1;
    //}

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    {
      if (msg->lParam & FVIRTKEY)
      {

        if (msg->wParam == VK_F1)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_ABOUT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_CHANGELOG, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_VERSION, 0);
            }

            return 1;
          }
        }
      } // FVIRTKEY

      if (msg->wParam == 'A')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_OPENFILES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == VK_RIGHT)
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_NEXT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == VK_LEFT)
      {
        if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_PREVIOUS, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'W')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_BW, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'B')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_BLUR, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'V')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_FLIPVERTICALLY, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'H')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_FLIPHORIZONTALLY, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'N')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_NEGATIVE, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'L')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_LOGTRANSFORMATION, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'I')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_ILLINIFY, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == '0')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_ROTATEBY0DEGREES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == '9')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_ROTATEBY90DEGREES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == '8')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_ROTATEBY180DEGREES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == '7')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_EDIT_ROTATEBY270DEGREES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EXIT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'P')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            //SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
          }

          return 1;
        }
      }

      //if (msg->wParam == 'L')
      //{
      //  if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
      //    !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
      //    !(GetAsyncKeyState(VK_MENU) & 0x8000))
      //  {
      //    if (!GetCapture())
      //    {
      //      HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
      //      SendMessage(edt, EM_SETSEL, 0, -1);
      //      SetFocus(edt);
      //    }

      //    return 1;
      //  }
      //}
      //if (msg->wParam == 'D')
      //{
      //  if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
      //    !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
      //    (GetAsyncKeyState(VK_MENU) & 0x8000))
      //  {
      //    if (!GetCapture())
      //    {
      //      HWND edt = GetDlgItem(g_mainwnd->Handle(), IDC_EDIT1);
      //      SendMessage(edt, EM_SETSEL, 0, -1);
      //      SetFocus(edt);
      //    }

      //    return 1;
      //  }
      //}
    }


    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP /* || msg->message == WM_CHAR */)
    {

    }
  }

  return 0;
}

void RSM_RunMessageLoop()
{
#if defined(_WIN32)
  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = RSM_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (IsDialogMessage(g_mainwnd->Handle(), &msg))
    {
      continue;
    }

    if (g_aboutwnd)
    {
      if (IsDialogMessage(g_aboutwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_changelogwnd)
    {
      if (IsDialogMessage(g_changelogwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_licwnd)
    {
      if (IsDialogMessage(g_licwnd->Handle(), &msg))
      {
        continue;
      }
    }

    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
#else
  for (;;)
  {
    MSG msg = { 0, };
    int x = RSI_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }
#endif
}
