#ifndef _RSM_PICTURE_WINDOWS_H_
#define _RSM_PICTURE_WINDOWS_H_

#include "mnemosyne/definitions.h"

#include "WDL/wingui/virtwnd.h"
#include "WDL/lice/lice.h"
#include "WDL/lice/lice_text.h"
#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"

class RSM_PictureWnd
{
public:
  explicit RSM_PictureWnd(HWND hwnd);
  ~RSM_PictureWnd();

  HWND Handle() { return m_hwnd; }

  void OpenFiles();
  void NextImage();
  void PreviousImage();
  void BlackAndWhite();
  void Blur();
  void FlipVertically();
  void FlipHorizontally();
  void Negative();
  void LogTransformation();
  void Illinify();
  void Rotate0();
  void Rotate90();
  void Rotate180();
  void Rotate270();

  static WDL_DLGRET PictureWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnCreate();
  void OnDestroy();
  void OnPaint();
  void OnLButtonUp();
  void OnSize();
  void OnTimer();
  void OnContextMenu();
  void OnCommand();
  WDL_DLGRET PictureWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  UINT m_msg;
  WPARAM m_wparam;
  LPARAM m_lparam;
  WDL_VirtualWnd_Painter m_painter;
  LICE_IBitmap *m_bm;
  LICE_IBitmap *m_pic;
  LICE_IBitmap *m_tmp;
  LICE_IFont *m_font;
  int m_bgc, m_txtc;
  HMENU m_contextmenu;

  WDL_PtrList<WDL_FastString> m_piclist;
  int m_picidx;

  void *m_gif;
  bool m_bw;
  bool m_blur;
  int m_degrees;
  bool m_vert;
  bool m_horz;
  bool m_neg;
  bool m_log;
  bool m_illinify;
};

#endif // _RSM_PICTURE_WINDOWS_H_
