!include "MUI2.nsh"
!include "LogicLib.nsh"

;Unicode true

;SetCompress off
SetCompressor zlib
;SetCompressor /solid LZMA
;SetCompressorDictSize 8
;RequestExecutionLevel highest
RequestExecutionLevel admin

;!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-install-alt.ico"
;!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\nsis3-uninstall.ico"
;!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\nsis3-metro.bmp"
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\orange-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\orange-uninstall.ico"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\orange.bmp"
!define MUI_COMPONENTSPAGE_NODESC
!define MUI_FINISHPAGE_NOAUTOCLOSE

!searchparse /file ..\src\phoebe\app_info.h '#define PHO_MAJOR_VERSION ' MAJOR
!searchparse /file ..\src\phoebe\app_info.h '#define PHO_MINOR_VERSION ' MINOR
!searchparse /file ..\src\phoebe\app_info.h '#define PHO_RELEASE "' RELEASE '"'
!searchparse /file ..\src\phoebe\app_info.h '#define PHO_COPYRIGHT "' COPYRIGHT '"'
!searchparse /file ..\src\phoebe\app_info.h '#define PHO_COMPANY_URL "' COMPANY '"'

Name "Phoebe"
OutFile "phoebe-${MAJOR}.${MINOR}${RELEASE}-x64-install.exe"
;BrandingText "Grafmin"

VIAddVersionKey "ProductName" "Phoebe"
VIAddVersionKey "CompanyName" "${COMPANY}"
VIAddVersionKey "FileDescription" "Phoebe installer (x64)"
VIAddVersionKey "FileVersion" "${MAJOR}.${MINOR}.0.0"
VIAddVersionKey "ProductVersion" "${MAJOR}.${MINOR}"
VIAddVersionKey "LegalCopyright" "${COPYRIGHT}"
VIProductVersion "${MAJOR}.${MINOR}.0.0"

InstallDir "$PROGRAMFILES64\Phoebe"

;Get installation folder from registry if available
InstallDirRegKey HKCU "Software\Phoebe (x64)" ""

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN $INSTDIR\phoebe.exe

!insertmacro MUI_PAGE_LICENSE "..\doc\license.txt"
!insertmacro MUI_PAGE_COMPONENTS
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
;AutoCloseWindow true

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES

!insertmacro MUI_LANGUAGE "English"

Section "Phoebe" SecPhoebe
  SectionIn RO

  SetOutPath "$INSTDIR"

  File "..\build\vc\x64\Release\phoebe.exe"
  ;File "..\build\vc\x64\Release\*.dll"
  File "..\build\vc\x64\Release\changelog.txt"
  File "..\build\vc\x64\Release\license.txt"
  File "..\build\vc\Win32\Release\documentation.txt"

  ;SetOutPath "$INSTDIR\ext"
  ;File /r "..\build\vc\x64\Release\ext\*.dll"

  SetOutPath "$INSTDIR\skin"
  File /r "..\build\vc\x64\Release\skin\*.*"

  ;Store installation folder
  WriteRegStr HKCU "Software\Phoebe (x64)" "" $INSTDIR

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\uninstall.exe"
SectionEnd

Section "Start menu shortcuts" SecStart
  SetOutPath "$SMPROGRAMS\Phoebe (x64)"
  CreateShortcut "$OUTDIR\Phoebe (x64).lnk" "$INSTDIR\phoebe.exe"
  CreateShortcut "$OUTDIR\Uninstall Phoebe (x64).lnk" "$INSTDIR\uninstall.exe"
SectionEnd

Section "Context menu entry (File Explorer)" SecContext
  WriteRegStr HKCR "*\shell\Phoebe (x64)" "" "Edit with Phoe&be (x64)"
  WriteRegStr HKCR "*\shell\Phoebe (x64)\command" "" '"$INSTDIR\phoebe.exe" "%1"'
SectionEnd

Section /o "Desktop icon" SecDesktop
  SetOutPath $DESKTOP
  CreateShortcut "$OUTDIR\Phoebe (x64).lnk" "$INSTDIR\phoebe.exe"
SectionEnd

;Language strings
LangString DESC_SecPhoebe ${LANG_ENGLISH} "Phoebe core (required)."
LangString DESC_SecStart ${LANG_ENGLISH} "Start menu shortcuts."
LangString DESC_SecDesktop ${LANG_ENGLISH} "Desktop icon."

;Assign language strings to sections
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
!insertmacro MUI_DESCRIPTION_TEXT ${SecPhoebe} $(DESC_SecPhoebe)
!insertmacro MUI_DESCRIPTION_TEXT ${SecStart} $(DESC_SecStart)
!insertmacro MUI_DESCRIPTION_TEXT ${SecDesktop} $(DESC_SecDesktop)
!insertmacro MUI_FUNCTION_DESCRIPTION_END

;--------------------------------
;Uninstaller Section

Section "Uninstall"
  StrCpy $1 "phoebe.exe"

retry:
  nsProcess::_FindProcess "$1"

  Pop $R0
  ${if} $R0 = 0
    MessageBox MB_RETRYCANCEL "Phoebe is running. Close Phoebe and hit Retry." /SD IDRETRY IDCANCEL cancel
    Goto retry
  ${endif}

  Delete "$DESKTOP\Phoebe (x64).lnk"
  Delete "$SMPROGRAMS\Phoebe (x64)\Phoebe (x64).lnk"
  Delete "$SMPROGRAMS\Phoebe (x64)\Uninstall Phoebe (x64).lnk"
  RMDir /r "$SMPROGRAMS\Phoebe (x64)"

  Delete "$INSTDIR\phoebe.exe"
  Delete "$INSTDIR\*.dll"
  Delete "$INSTDIR\changelog.txt"
  Delete "$INSTDIR\license.txt"
  Delete "$INSTDIR\documentation.txt"
  RMDir /r "$INSTDIR\ext"
  RMDir /r "$INSTDIR\skin"
  Delete "$INSTDIR\uninstall.exe"
  RMDir "$INSTDIR"

  DeleteRegKey /ifempty HKCU "Software\Phoebe (x64)"
  DeleteRegKey HKCR "*\shell\Phoebe (x64)"

  Goto cont

cancel:
  Abort

cont:
SectionEnd
