// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_INFO_H_
#define _PHOEBE_INFO_H_

#include <string.h>

#include "phoebe/git_sha1.h"

#define PHO_MAJOR_VERSION 1
#define PHO_MINOR_VERSION 03

#define PHO_RELEASE ""
#define PHO_SPECIAL ""

#define PHO_NAME "phoebe"
#define PHO_NAME_MARKETING "Phoebe"
#define PHO_COMPANY_URL "https://www.grafmin.gr/"
#define PHO_WEBSITE_URL "https://www.grafmin.gr/phoebe"
#define PHO_COPYRIGHT "Copyright (c) 2023-2025 Giorgos Vougioukas"

#define PHO_STRINGIFY_HELPER(x) #x
#define PHO_STRINGIFY(x) PHO_STRINGIFY_HELPER(x)

#define PHO_NAKED_VERSION \
  PHO_STRINGIFY(PHO_MAJOR_VERSION) \
  "." PHO_STRINGIFY(PHO_MINOR_VERSION) \
  PHO_RELEASE PHO_SPECIAL

#define PHO_FULL_VERSION \
  PHO_NAME_MARKETING " " PHO_NAKED_VERSION

#define PHO_GIT_SHA PHO_STRINGIFY(GIT_SHA1)

#define PHO_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(PHO_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define PHO_ARCH "x64"
  #elif defined(_M_IX86)
    #define PHO_ARCH "x86"
  #else
    #define PHO_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define PHO_ARCH "amd64"
  #elif defined(__i386__)
    #define PHO_ARCH "i686"
  #else
    #define PHO_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define PHO_ARCH "x86-64"
  #elif defined(__i386__)
    #define PHO_ARCH "i386"
  #else
    #define PHO_ARCH "unk"
  #endif
#endif

#endif // _PHOEBE_INFO_H_
