// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_DEFINITIONS_H_
#define _PHOEBE_DEFINITIONS_H_

#if defined(_WIN32)
#include <windows.h>
#include <windowsx.h>
#include <commctrl.h>
#include <process.h>
#else
#include "WDL/swell/swell.h"
#include "WDL/swell/swell-functions.h"
#endif

#include "phoebe/res/resource.h"

#include "WDL/wdltypes.h"
#include "WDL/win32_utf8.h"
#include "WDL/heapbuf.h"
#include "WDL/ptrlist.h"
#include "WDL/wdlstring.h"
#include "WDL/assocarray.h"

class PHO_AboutWnd;
class PHO_ChangelogWnd;
class PHO_LicenseWnd;
class PHO_MainWnd;
class PHO_PreferencesWnd;
class PHO_Preferences;
class PHO_SuperEditorWnd;
class PHO_SuperEditor;
class PHO_Cursor;
class PHO_SwitchWnd;
class LICE_IBitmap;

extern HINSTANCE g_inst;
extern UINT g_scrollmessage;
extern bool g_hasrequestedquit;

extern WDL_FastString g_argfile;
extern WDL_FastString g_modpath;
extern WDL_FastString g_setpath;
extern WDL_FastString g_inipath;
extern WDL_FastString g_text_ext;

extern PHO_Preferences *g_preferences;

extern PHO_MainWnd *g_mainwnd;
extern PHO_LicenseWnd *g_licwnd;
extern PHO_ChangelogWnd *g_changelogwnd;
extern PHO_PreferencesWnd *g_prefwnd;
extern PHO_AboutWnd *g_aboutwnd;
extern PHO_SuperEditorWnd *g_supereditorwnd;
extern PHO_SuperEditor *g_supereditor;
extern PHO_Cursor *g_cursor;
extern PHO_SwitchWnd *g_switchwnd;

extern HWND g_gotolinewnd;
extern HWND g_gotolineoffsetwnd;
extern HWND g_findwnd;
extern HWND g_replacewnd;

extern LICE_IBitmap *g_scrollbar;

extern WDL_PtrKeyedArray<const char *> g_pluginimport;
extern WDL_StringKeyedArray<void *> g_pluginexport;

extern void PHO_RunMessageLoop();
extern int PHO_ProcessMessage(MSG *msg);
extern WDL_DLGRET PHO_GotoLineWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET PHO_GotoLineOffsetWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET PHO_FindWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
extern WDL_DLGRET PHO_ReplaceWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

#endif // _PHOEBE_DEFINITIONS_H_
