// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_NCURSES_EDITOR_H_
#define _PHOEBE_NCURSES_EDITOR_H_

#ifndef CURSES_INSTANCE
#define CURSES_INSTANCE ((win32CursesCtx *)m_cursesCtx)
#endif

#include <string.h>
#include <stdlib.h>

#include "phoebe/definitions.h"
#include "WDL/win32_curses/curses.h"
#include "WDL/win32_curses/curses_editor.h"
// Time to panic
//#undef move
//#undef erase
//#undef sync

#define WM_TOGGLE_FOCUS (WM_USER + 200)

class PHO_PreviewEditor : public WDL_CursesEditor
{
public:
  PHO_PreviewEditor(void *curses_ctx);
  ~PHO_PreviewEditor();

  void ClearText();

  void SetParent(HWND parent);
  int onChar(int c);

private:
  HWND m_parent;
};

class PHO_PreferencesEditor : public WDL_CursesEditor
{
public:
  PHO_PreferencesEditor(void *curses_ctx);
  ~PHO_PreferencesEditor();

  void ClearText();

  void SetParent(HWND parent);
  int onChar(int c);

  void draw_bottom_line();

private:
  HWND m_parent;
};

#endif // _PHOEBE_NCURSES_EDITOR_H_
