// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_LICENSE_WND_H_
#define _PHOEBE_LICENSE_WND_H_

#include "phoebe/definitions.h"
#include "phoebe/app_info.h"

#include "WDL/fileread.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"

class PHO_LicenseWnd
{
public:
  PHO_LicenseWnd()
    : m_hwnd(NULL)
  {}

  ~PHO_LicenseWnd()
  {
    DestroyWindow(m_hwnd);
  }

  HWND Handle() const { return m_hwnd; }
  static WDL_DLGRET LicenseWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
#ifdef _WIN32
  INT_PTR OnCtlColorStatic(UINT msg, WPARAM wparam, LPARAM lparam);
#endif
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET LicenseWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;

  WDL_WndSizer m_resize;
};

#endif // _PHOEBE_LICENSE_WND_H_
