// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_PREFERENCES_H_
#define _PHOEBE_PREFERENCES_H_

#include "third_party/cJSON/cJSON.h"

#include <string.h>
#include <stdlib.h>

#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"

class PHO_Preferences
{
public:
  PHO_Preferences();
  ~PHO_Preferences();

  void Create();
  void Open(bool default_file = false);

  bool Parse(bool default_file = false);
  const char *GetParseError() const { return m_err.Get(); }

  void SetRelaunch(bool enable) { m_relaunch = enable; }
  bool WantRelaunch() const { return m_relaunch; }

  bool WantCurses() const;
  bool WantCursesRightFocus() const;
  int GetBackgroundColor() const;
  int GetActiveTextColor() const;
  int GetTextColor() const;
  bool WantPreserveDirectory() const;
  int GetTextFont() const;
  int GetTextFontHeight() const;
  bool ShowWhitespace() const;
  bool WantSpaceForTab() const;
  int GetTabSize() const;
  bool WantCRLF() const;

private:
  cJSON *m_pf;
  WDL_FastString m_err;
  bool m_relaunch;
};

#endif // _PHOEBE_PREFERENCES_H_
