// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_SWITCH_WND_H_
#define _PHOEBE_SWITCH_WND_H_

#include "phoebe/definitions.h"

#include "WDL/wdlstring.h"
#include "WDL/ptrlist.h"
#include "WDL/wingui/wndsize.h"

struct PHO_SwitchWindowInfo
{
  HWND hwnd;
  WDL_FastString text;
};

class PHO_SwitchWnd
{
public:
  PHO_SwitchWnd();
  ~PHO_SwitchWnd();

  HWND Handle() const { return m_hwnd; }
  void GotoSelectedWindow();

  static WDL_DLGRET SwitchWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET SwitchWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);

  static int windowtextcmp(const void *a, const void *b)
  {
    PHO_SwitchWindowInfo *aa = *(PHO_SwitchWindowInfo **)a;
    PHO_SwitchWindowInfo *bb = *(PHO_SwitchWindowInfo **)b;
    return stricmp(aa->text.Get(), bb->text.Get());
  }

  HWND m_hwnd;
  HWND m_list;
  WDL_WndSizer m_resize;
  WDL_PtrList<PHO_SwitchWindowInfo> m_swi;
};

#endif // _PHOEBE_SWITCH_WND_H_
