// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "phoebe/changelog_wnd.h"

#define PHO_CHANGELOG_UPDATE_ID 331
#define PHO_CHANGELOG_UPDATE_MS 50

static win32CursesCtx s_curses_ctx;

PHO_ChangelogWnd::PHO_ChangelogWnd()
  : m_hwnd(NULL)
  , m_preview(&s_curses_ctx)
{}

PHO_ChangelogWnd::~PHO_ChangelogWnd()
{
  DestroyWindow(m_hwnd);
}

void PHO_ChangelogWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{
  HWND cc = GetDlgItem(m_hwnd, IDC_CUSTOM1);
  curses_setWindowContext(cc, &s_curses_ctx);

  m_resize.init(m_hwnd);
  m_resize.init_itemhwnd(cc, 0.0f, 0.0f, 1.0f, 1.0f);

  int x = GetPrivateProfileInt(PHO_NAME, "changelog_wnd_x", 0, g_inipath.Get());
  int y = GetPrivateProfileInt(PHO_NAME, "changelog_wnd_y", 50, g_inipath.Get());
  SetWindowPos(m_hwnd, NULL, x, y, 620, 505, SWP_NOZORDER | SWP_NOACTIVATE);

  WDL_FastString changelog;
  changelog.Set(g_modpath.Get());
  changelog.Append("changelog.txt");

  m_preview.SetParent(m_hwnd);
  m_preview.init(changelog.Get());
  m_preview.draw();
  m_preview.setCursor();

  SetFocus(cc);
  SetTimer(m_hwnd, PHO_CHANGELOG_UPDATE_ID, PHO_CHANGELOG_UPDATE_MS, NULL);
}

void PHO_ChangelogWnd::OnTimer(WPARAM wparam, LPARAM lparam)
{
  if (wparam == PHO_CHANGELOG_UPDATE_ID)
  {
    m_preview.RunEditor();
  }
}

void PHO_ChangelogWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{
  KillTimer(m_hwnd, PHO_CHANGELOG_UPDATE_ID);
  m_preview.ClearText();

  RECT r;
  GetWindowRect(m_hwnd, &r);

  WDL_FastString rleft, rtop;
  rleft.SetFormatted(32, "%d", r.left);
  rtop.SetFormatted(32, "%d", r.top);

  WritePrivateProfileString(PHO_NAME,"changelog_wnd_x", rleft.Get(), g_inipath.Get());
  WritePrivateProfileString(PHO_NAME,"changelog_wnd_y", rtop.Get(), g_inipath.Get());
}

void PHO_ChangelogWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  if (wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();
  }
}

void PHO_ChangelogWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{
  switch(LOWORD(wparam))
  {
    case IDCANCEL:
    {
      if (g_changelogwnd) { delete g_changelogwnd; g_changelogwnd = NULL; }
    }
    break;
  }
}

void PHO_ChangelogWnd::OnSysCommand(WPARAM wparam, LPARAM lparam)
{
  if (LOWORD(wparam) == SC_CLOSE)
  {
    if (g_changelogwnd) { delete g_changelogwnd; g_changelogwnd = NULL; }
  }
}

WDL_DLGRET PHO_ChangelogWnd::ChangelogWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  PHO_ChangelogWnd *self = (PHO_ChangelogWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (PHO_ChangelogWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->ChangelogWndLoop(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET PHO_ChangelogWnd::ChangelogWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_TIMER: OnTimer(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
    case WM_SYSCOMMAND: OnSysCommand(wparam, lparam); break;
  }

  return 0;
}
