// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_CURSOR_H_
#define _PHOEBE_CURSOR_H_

#include "phoebe/definitions.h"

#define PHO_UPDATE_CURSOR 130
#define PHO_UPDATE_CURSOR_MS 50

class PHO_Cursor
{
public:
  PHO_Cursor();
  ~PHO_Cursor();

  void SingleLetter(const RECT *r);
  void ViewSurface(const RECT *r);
  int GetViewSurfaceLines() const;
  int GetViewSurfaceColumns() const;
  void GetCursor(bool *visible, RECT *r) const;
  void GetPosition(int *x, int *y) const;
  void GetDeltaPosition(int *x, int *y) const;
  void SetPosition(int x, int y);
  int GetX() const;
  void SetX(int x);
  int GetY() const;
  void SetY(int y);
  int GetWidth() const;
  int GetHeight() const;
  void MoveToTop();
  void MoveToX(int x);
  void MoveToY(int y);
  int GetBottom() const;
  int GetTop() const;
  int GetRight() const;
  int GetLeft() const;

private:
  void HideMouseCursor();

  int m_x;
  int m_y;
  int m_w;
  int m_h;
  int m_vx;
  int m_vy;
  bool m_vis;
  int m_bt;
  RECT m_vs;
  RECT m_sl;
};

#endif // _PHOEBE_CURSOR_H_
