// Copyright (c) 2022 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_MAIN_WND_H_
#define _PHOEBE_MAIN_WND_H_

#include "phoebe/definitions.h"

#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/wingui/virtwnd-controls.h"
#include "WDL/lineparse.h"
#include "WDL/mutex.h"
#include "WDL/aggarray.h"

class PHO_MainWnd
{
public:
  PHO_MainWnd();
  ~PHO_MainWnd();

  HWND Handle() const { return m_hwnd; }

  void GotoLine();
  void GotoLineOffset();
  void ToggleFullscreen();
  void SwitchWindow();
  void Find();
  void Replace();
  void FindReplaceNext();
  void FindReplacePrevious();

  const char *GetOrigTitle() const;

  static WDL_DLGRET MainWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void OnInitDialog(WPARAM wparam, LPARAM lparam);
  void OnSysCommand(WPARAM wparam, LPARAM lparam);
  INT_PTR OnClose(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnMove(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  INT_PTR OnNotify(WPARAM wparam, LPARAM lparam);
  void OnContextMenu(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  INT_PTR OnCtrlColorEdit(UINT msg, WPARAM wparam, LPARAM lparam);
  void OnActivateApp(WPARAM wparam, LPARAM lparam);
  void OnNCLButtonDown(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET MainWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewTreeProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewListProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewEditProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  static int sort_by_file_path(const void *a, const void *b)
  {
    WDL_FastString *s1, *s2;
    s1 = *(WDL_FastString **)a;
    s2 = *(WDL_FastString **)b;
    return stricmp(s1->Get(), s2->Get());
  }

  HWND m_hwnd;

  int m_x, m_y, m_w, m_h;
  WDL_WndSizer m_resize;
  HMENU m_main_menu;
  LICE_IBitmap *m_tbm;
  LICE_IBitmap *m_lbm;

  WDL_FastString m_strbuf;

  LICE_IFont *m_font;
  HBRUSH m_brush;

  WDL_FastString m_titleorig;

  bool m_fullscreen;
  LONG_PTR m_style;
  LONG_PTR m_exstyle;
  bool m_maximized;
  int m_bg;
};

#endif // _PHOEBE_MAIN_WND_H_
