// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "phoebe/definitions.h"
#include "phoebe/about_wnd.h"
#include "phoebe/changelog_wnd.h"
#include "phoebe/license_wnd.h"
#include "phoebe/main_wnd.h"
#include "phoebe/preferences_wnd.h"
#include "phoebe/preferences.h"
#include "phoebe/super_editor_wnd.h"
#include "phoebe/super_editor.h"
#include "phoebe/switch_wnd.h"

#include "WDL/wdlutf8.h"

// VK_OEM_1: semicolon (0xBA)
// VK_OEM_2: slash (0xBF)
// VK_OEM_3: tilde (0xC0)
// VK_OEM_4: left bracket (0xDB)
// VK_OEM_5: backslash (0xDC)
// VK_OEM_6: right bracket (0xDD)
// VK_OEM_7: quote (0xDE)
// VK_OEM_PLUS: equal (0xBB)
// VK_OEM_MINUS: dash (0xBD)
// VK_OEM_COMMA: comma (0xBC)
// VK_OEM_PERIOD: period (0xBE)

int PHO_ProcessMessage(MSG *msg)
{
  if (g_mainwnd && (msg->hwnd == g_mainwnd->Handle() || IsChild(g_mainwnd->Handle(), msg->hwnd)))
  {
    if (msg->wParam == VK_CONTROL &&
        (msg->message == WM_KEYDOWN ||
          msg->message == WM_KEYUP))
    {
      if (GetCapture() == g_mainwnd->Handle())
      {
        //InvalidateRect(g_mainwnd->Handle(), NULL, FALSE);
      }
    }

    //if (msg->message == WM_MOUSEWHEEL)
    //{
    //  SendMessage(msg->hwnd, WM_MOUSEWHEEL, msg->wParam, msg->lParam);

    //  return 1;
    //}

    //if (g_switchwnd && (msg->hwnd == g_switchwnd->Handle() || IsChild(g_switchwnd->Handle(), msg->hwnd)))
    //{
    //  if (GetFocus() == GetDlgItem(g_switchwnd->Handle(), IDC_LIST1))
    //  {
    //    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    //    {
    //      if (msg->lParam & FVIRTKEY)
    //      {
    //        if (msg->wParam == VK_RETURN)
    //        {
    //          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
    //            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
    //            !(GetAsyncKeyState(VK_MENU) & 0x8000))
    //          {
    //            if (!GetCapture())
    //            {
    //              g_switchwnd->GotoSelectedWindow();
    //            }

    //            return 1;
    //          }
    //        }
    //      } // FVIRTKEY
    //    }
    //  }
    //}

    if (msg->message == WM_CHAR)
    {
      if ((!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
        !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
        !(GetAsyncKeyState(VK_MENU) & 0x8000)) ||
        (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
        (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
        !(GetAsyncKeyState(VK_MENU) & 0x8000)))
      {
        SendMessage(g_supereditorwnd->Handle(), WM_CHAR, msg->wParam, msg->lParam);
      }
    }

    if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN /* || msg->message == WM_CHAR */)
    //if (msg->message == WM_KEYDOWN || msg->message == WM_SYSKEYDOWN || msg->message == WM_CHAR)
    {
      if (msg->lParam & FVIRTKEY)
      {
        if (msg->wParam == VK_F1)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_ABOUT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F2)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_CHANGELOG, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F3)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_HELP_VERSION, 0);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->FindReplaceNext();
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->FindReplacePrevious();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F9)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->ToggleCRLF();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F10)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->ToggleSpace();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_F11)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->ToggleFullscreen();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_TAB)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_mainwnd->SwitchWindow();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_LEFT)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveLeft();
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveLeft();
              g_supereditor->TextSelection(true);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->JumpWordLeft();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_RIGHT)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveRight();
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveRight();
              g_supereditor->TextSelection(true);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->JumpWordRight();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_UP)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveUp();
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_UP, 0);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveUp();
              g_supereditor->TextSelection(true);
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_UP, 0);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->MoveTextUp();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_DOWN)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveDown();
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_DOWN, 0);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveDown();
              g_supereditor->TextSelection(true);
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_DOWN, 0);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->MoveTextDown();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_HOME)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveStart();
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveStart();
              g_supereditor->TextSelection(true);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveTop();
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_HOME, 0);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveTop();
              g_supereditor->TextSelection(true);
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_HOME, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_END)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveEnd();
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveEnd();
              g_supereditor->TextSelection(true);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MoveBottom();
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_END, 0);
            }

            return 1;
          }
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MoveBottom();
              g_supereditor->TextSelection(true);
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_END, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_PRIOR)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MovePageUp();
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_PRIOR, 0);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MovePageUp();
              g_supereditor->TextSelection(true);
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_PRIOR, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_NEXT)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(false);
              g_supereditor->MovePageDown();
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_NEXT, 0);
            }

            return 1;
          }
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->TextSelection(true);
              g_supereditor->MovePageDown();
              g_supereditor->TextSelection(true);
              SendMessage(g_supereditorwnd->Handle(), WM_KEYDOWN, VK_NEXT, 0);
            }

            return 1;
          }
        }
        if (msg->wParam == VK_ESCAPE)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->InitialState();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_RETURN)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->NewLine();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_TAB)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->InsertTab();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_TAB)
        {
          if (!(GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->RemoveTab();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_BACK)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->DeleteWordBackspace();
            }

            return 1;
          }
        }
        if (msg->wParam == VK_DELETE)
        {
          if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
            !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
            !(GetAsyncKeyState(VK_MENU) & 0x8000))
          {
            if (!GetCapture())
            {
              g_supereditor->DeleteWord();
            }

            return 1;
          }
        }
      } // FVIRTKEY

      if (msg->wParam == 'F')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->Find();
          }

          return 1;
        }
      }
      if (msg->wParam == 'R')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->Replace();
          }

          return 1;
        }
      }
      if (msg->wParam == 'W')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_supereditorwnd->ToggleWhitespace();
          }

          return 1;
        }
      }
      if (msg->wParam == 'X')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_supereditor->CutSelectedText();
          }

          return 1;
        }
      }
      if (msg->wParam == 'C')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_supereditor->CopySelectedText();
          }

          return 1;
        }
      }
      if (msg->wParam == 'V')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_supereditor->PasteSelectedText();
          }

          return 1;
        }
      }
      if (msg->wParam == 'S')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_SAVE_TEXT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'S')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_SAVEAS_TEXT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'G')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->GotoLine();
          }

          return 1;
        }
      }
      if (msg->wParam == 'G')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_mainwnd->GotoLineOffset();
          }

          return 1;
        }
      }
      if (msg->wParam == 'L')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_supereditor->ShowLines();
          }

          return 1;
        }
      }
      if (msg->wParam == 'L')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          (GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            g_supereditor->ShowOffsetLines();
          }

          return 1;
        }
      }
      if (msg->wParam == 'N')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_NEW_TEXT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'O')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_OPEN_TEXT, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'P')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_OPTIONS_PREFERENCES, 0);
          }

          return 1;
        }
      }
      if (msg->wParam == 'Q')
      {
        if ((GetAsyncKeyState(VK_CONTROL) & 0x8000) &&
          !(GetAsyncKeyState(VK_SHIFT) & 0x8000) &&
          !(GetAsyncKeyState(VK_MENU) & 0x8000))
        {
          if (!GetCapture())
          {
            SendMessage(g_mainwnd->Handle(), WM_COMMAND, ID_FILE_EXIT, 0);
          }

          return 1;
        }
      }
    }

    if (msg->message == WM_KEYUP || msg->message == WM_SYSKEYUP /* || msg->message == WM_CHAR */)
    {

    }
  }

  return 0;
}

void PHO_RunMessageLoop()
{
#if defined(_WIN32)
  for (;;) // Justin Frankel in the loop
  {
    MSG msg = { 0, };
    int vvv = GetMessage(&msg, NULL, 0, 0);

    if (!vvv)
    {
      break;
    }

    if (vvv < 0)
    {
      Sleep(10);
      continue;
    }

    if (!msg.hwnd)
    {
      DispatchMessage(&msg);
      continue;
    }

    vvv = PHO_ProcessMessage(&msg);

    if (vvv > 0)
    {
      continue;
    }

    if (g_mainwnd)
    {
      if (IsDialogMessage(g_mainwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_switchwnd)
    {
      if (IsDialogMessage(g_switchwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_changelogwnd)
    {
      if (IsDialogMessage(g_changelogwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_prefwnd)
    {
      if (IsDialogMessage(g_prefwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_licwnd)
    {
      if (IsDialogMessage(g_licwnd->Handle(), &msg))
      {
        continue;
      }
    }

    if (g_aboutwnd)
    {
      if (IsDialogMessage(g_aboutwnd->Handle(), &msg))
      {
        continue;
      }
    }

    HWND parent = NULL;
    HWND temp = msg.hwnd;

    do
    {
      if (GetClassLong(temp, GCW_ATOM) == (INT)32770)
      {
        parent = temp;

        if (!(GetWindowLong(temp, GWL_STYLE) &WS_CHILD))
        {
          break;  // not a child, exit
        }
      }
    }
    while (temp = GetParent(temp));

    if (parent && IsDialogMessage(parent, &msg))
    {
      continue;
    }

    TranslateMessage(&msg);
    DispatchMessage(&msg);
  }
#else
  for (;;)
  {
    MSG msg = { 0, };
    int x = PHO_ProcessMessage(&msg);

    if (x == 0)
    {
      break;
    }
  }
#endif
}
