// Copyright (c) 2021 Giorgos Vougioukas
//
// The plug-in mechanism derived from REAPER plug-in API
// Copyright (c) 2006-2009, Cockos Incorporated
//
// This software is provided 'as-is', without any express or implied
// warranty.  In no event will the authors be held liable for any damages
// arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose,
// including commercial applications, and to alter it and redistribute it
// freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//     claim that you wrote the original software. If you use this software
//     in a product, an acknowledgment in the product documentation would be
//     appreciated but is not required.
//  2. Altered source versions must be plainly marked as such, and must not be
//     misrepresented as being the original software.
//  3. This notice may not be removed or altered from any source distribution.
//
//  Notes: the C++ interfaces used require MSVC on win32, or at least the
//  MSVC-compatible C++ ABI. Sorry, mingw users :(

#ifndef _PHOEBE_PLUGIN_PUBLIC_H_
#define _PHOEBE_PLUGIN_PUBLIC_H_

#ifdef _WIN32
#include <windows.h>

#define PHO_PLUGIN_EXPORT __declspec(dllexport)
#define PHO_PLUGIN_HINSTANCE HINSTANCE
#else
#include <pthread.h>
#include "WDL/swell/swell.h"

#define PHO_PLUGIN_EXPORT __attribute__((visibility("default")))
#define PHO_PLUGIN_HINSTANCE void *
#endif

#include "WDL/wdltypes.h"

#define PHO_PLUGIN_ENTRYPOINT phoebe_plugin_entry
#define PHO_PLUGIN_ENTRYPOINT_NAME "phoebe_plugin_entry"

#define PHO_PLUGIN_VERSION 120

struct PHO_PluginInfo
{
  int caller_version;

  HWND hwnd_main;

  int (*Register)(const char *name, void *info_struct);

  void *(*GetFunc)(const char *name);
};

#endif // _PHOEBE_PLUGIN_PUBLIC_H_
