// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _PHOEBE_SUPER_EDITOR_WND_H_
#define _PHOEBE_SUPER_EDITOR_WND_H_

#include "phoebe/definitions.h"
#include "phoebe/super_editor.h"
#include "phoebe/view.h"

//#define PHO_ENSUREVISIBLE (WM_USER + 200)

#include "WDL/heapbuf.h"
#include "WDL/wdlstring.h"
#include "WDL/wingui/wndsize.h"
#include "WDL/wingui/virtwnd.h"
#include "WDL/lice/lice.h"

class PHO_SuperEditorWnd
{
public:
  explicit PHO_SuperEditorWnd(HWND hwnd);
  ~PHO_SuperEditorWnd();

  HWND Handle() const { return m_hwnd; }

  void ToggleWhitespace();

  static WDL_DLGRET SuperEditorWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);
private:
  void AskForFullRender();
  void OnCreate(WPARAM wparam, LPARAM lparam);
  void OnDestroy(WPARAM wparam, LPARAM lparam);
  void OnSize(WPARAM wparam, LPARAM lparam);
  void OnCommand(WPARAM wparam, LPARAM lparam);
  void OnPaint(WPARAM wparam, LPARAM lparam);
  void OnLButtonDown(WPARAM wparam, LPARAM lparam);
  void OnLButtonUp(WPARAM wparam, LPARAM lparam);
  void OnMouseMove(WPARAM wparam, LPARAM lparam);
  void OnTimer(WPARAM wparam, LPARAM lparam);
  void OnVScroll(WPARAM wparam, LPARAM lparam);
  void OnKeyDown(WPARAM wparam, LPARAM lparam);
  void OnMouseWheel(WPARAM wparam, LPARAM lparam);
  WDL_DLGRET SuperEditorWndLoop(UINT msg, WPARAM wparam, LPARAM lparam);
  static WDL_DLGRET NewSuperEditorWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam);

  HWND m_hwnd;
  WDL_WndSizer m_resize;
  LICE_IBitmap *m_bm;
  LICE_IFont *m_font;
  WDL_String m_strbuf;
  PHO_View m_view;
  int m_textheight;
  int m_textpage;
  int m_letterheight;
  bool m_showwhitespace;
  int m_lastx;
  int m_lasty;
  int m_lastoffx;
  int m_lastoffy;
  int m_lastmx;
  int m_topln;
  int m_bg;
  int m_fg;
  int m_at;
};

#endif // _PHOEBE_SUPER_EDITOR_WND_H_
