rem Cleanup
rem =======

rem del *.zip
rem del *.exe
rem del changelog.txt

copy ..\doc\changelog.txt .\

rem Rhea x86 (installer)
rem ======================

makensis rhea_x86.nsi

rem Rhea x64 (installer)
rem ======================

makensis rhea_x64.nsi

rem Retrieve major/minor version
rem ============================

setlocal enabledelayedexpansion

for /f "delims=" %%a in ('findstr /b /c:"#define RHEA_MAJOR_VERSION " ..\src\rhea\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set major_ver="%pwd%"
set maj=%major_ver:~28,1%

for /f "delims=" %%a in ('findstr /b /c:"#define RHEA_MINOR_VERSION " ..\src\rhea\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set minor_ver="%pwd%"
set min=%minor_ver:~28,2%

for /f "delims=" %%a in ('findstr /b /c:"#define RHEA_RELEASE " ..\src\rhea\app_info.h') do (
  set pwd=%%a
  set "pwd=!pwd:Password: =!"
)

set release="%pwd%"
set rel=%release:~23%

rem Rhea x86 (portable)
rem =====================

rem Note: -mx=1 (fastest), -mx=3 (fast), nothing or -mx=5 (normal)

del rhea-%maj%.%min%%rel%-x86.zip
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\rhea.exe
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\ext\
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\skin\
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\*.dll
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\changelog.txt
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\license.txt
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip ..\build\vc\Win32\Release\documentation.txt
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x86.zip portable
7z d -r rhea-%maj%.%min%%rel%-x86.zip *.lib
7z d -r rhea-%maj%.%min%%rel%-x86.zip *.pdb
7z d -r rhea-%maj%.%min%%rel%-x86.zip *.exp
7z t rhea-%maj%.%min%%rel%-x86.zip * -r

rem Rhea x64 (portable)
rem =====================

del rhea-%maj%.%min%%rel%-x64.zip
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\rhea.exe
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\ext\
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\skin\
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\*.dll
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\changelog.txt
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\license.txt
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip ..\build\vc\x64\Release\documentation.txt
7z a -tzip -mx=1 rhea-%maj%.%min%%rel%-x64.zip portable
7z d -r rhea-%maj%.%min%%rel%-x64.zip *.lib
7z d -r rhea-%maj%.%min%%rel%-x64.zip *.pdb
7z d -r rhea-%maj%.%min%%rel%-x64.zip *.exp
7z t rhea-%maj%.%min%%rel%-x64.zip * -r

cd ..
git archive --format=zip --prefix=GV-852/ HEAD > pack\rhea-%maj%.%min%%rel%-src.zip
git archive --format=tar.gz --prefix=GV-852/ HEAD > pack\rhea-%maj%.%min%%rel%-src.tar.gz

pause
