// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_ANTIDOTE_INPUT_H_
#define _RHEA_ANTIDOTE_INPUT_H_

#include "rhea/definitions.h"

#include "third_party/libebur128/ebur128/ebur128.h"

#include "WDL/wdlstring.h"
#include "WDL/fileread.h"
#include "WDL/queue.h"

class RHEA_AntidoteInput
{
public:
  RHEA_AntidoteInput(
    const char *filename,
    WDL_FileRead *fileread,
    const char *input_filename,
    int channels, double orig_srate);
  ~RHEA_AntidoteInput();

  void SetTitle(const char *title);
  void SetArtist(const char *artist);
  const char *GetTitle() const;
  const char *GetArtist() const;

  void ebur128info(bool ebur128,
    bool ebur128downwardonly,
    double ebur128reference,
    int ebur128mode,
    double ebur128momentary,
    double ebur128shortterm,
    int ebur128momentarywindow,
    int ebur128shorttermwindow,
    double ebur128integrated,
    double ebur128range,
    double ebur128samplepeak,
    double ebur128truepeak,
    double ebur128gain,
    int momentarywindow,
    int shorttermwindow);

  bool get_ebur128() const { return m_ebur128; }
  bool get_ebur128downwardonly() const { return m_ebur128downwardonly; }
  double get_ebur128reference() const { return m_ebur128reference; }
  int get_ebur128mode() const { return m_ebur128mode; }
  double get_ebur128momentary() const { return m_ebur128momentary; }
  double get_ebur128shortterm() const { return m_ebur128shortterm; }
  int get_ebur128momentarywindow() const { return m_ebur128momentarywindow; }
  int get_ebur128shorttermwindow() const { return m_ebur128shorttermwindow; }
  double get_ebur128integrated() const { return m_ebur128integrated; }
  double get_ebur128range() const { return m_ebur128range; }
  double get_ebur128samplepeak() const { return m_ebur128samplepeak; }
  double get_ebur128truepeak() const { return m_ebur128truepeak; }
  double get_ebur128gain() const { return m_ebur128gain; }
  int get_momentarywindow() const { return m_momentarywindow; }
  int get_shorttermwindow() const { return m_shorttermwindow; }

  const char *GetType();
  const char *GetFileName();
  int GetChannels();
  double GetSampleRate();
  double GetLength();
  int GetBitsPerSample();
  double GetPosition();
  void Seek(double time);
  bool IsReverse() const;
  void SetReverse(bool state);
  int GetSamples(SAM *buffer, int length);
  bool IsStreaming();
  int Extended(int call, void *parm1, void *parm2, void *parm3);

private:
  WDL_FastString m_fn;
  WDL_FileRead *m_fr;
  int m_bitdepth;
  double m_srate;
  WDL_FastString m_ifn;

  bool m_ebur128;
  bool m_ebur128downwardonly;
  double m_ebur128reference;
  int m_ebur128mode;
  double m_ebur128momentary;
  double m_ebur128shortterm;
  int m_ebur128momentarywindow;
  int m_ebur128shorttermwindow;
  double m_ebur128integrated;
  double m_ebur128range;
  double m_ebur128samplepeak;
  double m_ebur128truepeak;
  double m_ebur128gain;
  int m_momentarywindow;
  int m_shorttermwindow;

  WDL_TypedQueue<SAM> m_buffer_queue;

  bool m_eof;
  double m_position;
  WDL_TypedBuf<SAM> m_buffer;
  WDL_HeapBuf m_rawbuf;
  bool m_rev;

  int m_nch;
  double m_orig_srate;

  WDL_FastString m_title;
  WDL_FastString m_artist;
};

#endif // _RHEA_ANTIDOTE_INPUT_H_
