// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#ifndef _RHEA_INFO_H_
#define _RHEA_INFO_H_

#include <string.h>

#include "rhea/git_sha1.h"

#define RHEA_MAJOR_VERSION 1
#define RHEA_MINOR_VERSION 03

#define RHEA_RELEASE ""
#define RHEA_SPECIAL ""

#define RHEA_NAME "rhea"
#define RHEA_NAME_MARKETING "Rhea"
#define RHEA_COMPANY_URL "https://www.grafmin.gr/"
#define RHEA_WEBSITE_URL "https://www.grafmin.gr/rhea"
#define RHEA_COPYRIGHT "Copyright (c) 2022-2025 Giorgos Vougioukas"

#define RHEA_STRINGIFY_HELPER(x) #x
#define RHEA_STRINGIFY(x) RHEA_STRINGIFY_HELPER(x)

#define RHEA_NAKED_VERSION \
  RHEA_STRINGIFY(RHEA_MAJOR_VERSION) \
  "." RHEA_STRINGIFY(RHEA_MINOR_VERSION) \
  RHEA_RELEASE RHEA_SPECIAL

#define RHEA_FULL_VERSION \
  RHEA_NAME_MARKETING " " RHEA_NAKED_VERSION

#define RHEA_GIT_SHA RHEA_STRINGIFY(GIT_SHA1)

#define RHEA_TIMESTAMP __DATE__ " " __TIME__

inline bool IsStableRelease()
{
  if (strlen(RHEA_RELEASE)) return false;

  return true;
}

#if defined(_MSC_VER)
  #if defined(_M_AMD64) || defined(_M_X64)
    #define RHEA_ARCH "x64"
  #elif defined(_M_IX86)
    #define RHEA_ARCH "x86"
  #else
    #define RHEA_ARCH "unk"
  #endif
#elif defined(__linux__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define RHEA_ARCH "amd64"
  #elif defined(__i386__)
    #define RHEA_ARCH "i686"
  #else
    #define RHEA_ARCH "unk"
  #endif
#elif defined(__APPLE__) && (defined(__clang__) || defined(__GNUC__))
  #if defined(__amd64__) || defined(__X86_64__)
    #define RHEA_ARCH "x86-64"
  #elif defined(__i386__)
    #define RHEA_ARCH "i386"
  #else
    #define RHEA_ARCH "unk"
  #endif
#endif

#endif // _RHEA_INFO_H_
