// Copyright (c) 2021 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/definitions.h"
#include "rhea/about_wnd.h"
#include "rhea/changelog_wnd.h"
#include "rhea/license_wnd.h"
#include "rhea/main_wnd.h"
#include "rhea/preferences_wnd.h"
#include "rhea/preferences.h"
#include "rhea/media_input.h"
#include "rhea/hestia.h"
#include "rhea/track.h"
#include "rhea/peaks.h"
#include "rhea/waveform_wnd.h"
#include "rhea/search_wnd.h"
#include "rhea/database.h"
#include "rhea/query.h"

#include "WDL/lice/lice.h"

//#include "rhea/rhea_plugin.h"

static void free_str(const char *p) { free((void *)p); }

HINSTANCE g_inst = NULL;
UINT g_scrollmessage;
bool g_hasrequestedquit = false;

WDL_FastString g_modpath;
WDL_FastString g_setpath;
WDL_FastString g_inipath;
WDL_FastString g_media_ext(".flac .mp3 .ogg .wv .wav .aiff .opus");


RHEA_IAudioStreamer *g_audiostreamer = NULL;
RHEA_Preferences *g_preferences = NULL;
RHEA_MediaInput *g_mediainput = NULL;
RHEA_Hestia *g_hestia = NULL;
RHEA_Peaks *g_peaks = NULL;
RHEA_Database *g_database = NULL;
RHEA_Query *g_query = NULL;

RHEA_MainWnd *g_mainwnd = NULL;
RHEA_LicenseWnd *g_licwnd = NULL;
RHEA_ChangelogWnd *g_changelogwnd = NULL;
RHEA_PreferencesWnd *g_prefwnd = NULL;
RHEA_AboutWnd *g_aboutwnd = NULL;
RHEA_WaveformWnd *g_waveformwnd = NULL;
RHEA_SearchWnd *g_searchwnd = NULL;

LICE_IBitmap *g_scrollbar = NULL;

WDL_PtrKeyedArray<const char *> g_pluginimport(free_str);
WDL_StringKeyedArray<void *> g_pluginexport;

void RHEA_OnAudioData(WDL_TypedBuf<SAM> *output, int frame_count, int nch)
{
  g_hestia->AudioData(output, frame_count, nch);
}

void RHEA_OnMediaInputDeck(WDL_PtrList<RHEA_Track> *decks)
{
  g_mediainput->DeckTrackInputs(decks);
}

void RHEA_OnMediaInputSampler(WDL_PtrList<RHEA_Track> *samplers)
{
  g_mediainput->SamplerTrackInputs(samplers);
}

double RHEA_GetAudioDeviceSamplerate() { return g_preferences->GetAudioDeviceSamplerate(); }
int RHEA_GetAudioDeviceBitDepth() { return g_preferences->GetAudioDeviceBitDepth(); }
int RHEA_GetAudioDeviceOutputChannels() { return g_preferences->GetAudioDeviceOutputChannels(); }

void RHEA_GetDiskReadMode(int *rmode, int *rbufsize, int *rnbufs)
{
  g_preferences->GetDiskReadMode(rmode, rbufsize, rnbufs);
}

void RHEA_GetDiskWriteMode(int *wmode, int *wbufsize, int *wminbufs, int *wmaxbufs)
{
  g_preferences->GetDiskWriteMode(wmode, wbufsize, wminbufs, wmaxbufs);
}

int RHEA_GetDiskIOPriority() { return g_preferences->GetDiskIOPriority(); }
int RHEA_GetDiskIOSleepStep() { return g_preferences->GetDiskIOSleepStep(); }
int RHEA_GetAntidoteBitDepth() { return g_preferences->GetAntidoteBitDepth(); }
int RHEA_GetAudioSystem() { return g_preferences->GetAudioSystem(); }

void RHEA_GetResampleMode(bool *interp, int *filtercnt,
  bool *sinc, int *sinc_size, int *sinc_interpsize)
{
  g_preferences->GetResampleMode(interp, filtercnt, sinc, sinc_size, sinc_interpsize);
}

bool RHEA_GetWASAPIExclusiveMode() { return g_preferences->GetWASAPIExclusiveMode(); }
