// Copyright (c) 2019 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/editor.h"
#include "rhea/definitions.h"
#include "rhea/main_wnd.h"

#include "third_party/cJSON/cJSON.h"

#include "WDL/wdlstring.h"
#include "WDL/filewrite.h"

#define RHEA_CTRL_KEY_DOWN (GetAsyncKeyState(VK_CONTROL)&0x8000)
#define RHEA_SHIFT_KEY_DOWN (GetAsyncKeyState(VK_SHIFT)&0x8000)
#define RHEA_ALT_KEY_DOWN (GetAsyncKeyState(VK_MENU)&0x8000)

RHEA_PreviewEditor::RHEA_PreviewEditor(void *curses_ctx)
  : WDL_CursesEditor(curses_ctx)
{
  m_indent_size = 2;

  /*
  init_pair(1, COLOR_WHITE, COLOR_BLUE);     // COLOR_BOTTOMLINE
  init_pair(2, COLOR_BLACK, COLOR_CYAN);     // COLOR_SELECTION
  init_pair(3, RGB(0,255,255),COLOR_BLACK);  // SYNTAX_HIGHLIGHT1
  init_pair(4, RGB(0,255,0),COLOR_BLACK);    // SYNTAX_HIGHLIGHT2
  init_pair(5, RGB(96,128,192),COLOR_BLACK); // SYNTAX_COMMENT
  init_pair(6, COLOR_WHITE, COLOR_RED);      // SYNTAX_ERROR
  init_pair(7, RGB(255,255,0), COLOR_BLACK); // SYNTAX_FUNC
  init_pair(8, RGB(255,128,128), COLOR_BLACK);  // SYNTAX_REGVAR
  init_pair(9, RGB(0,192,255), COLOR_BLACK);    // SYNTAX_KEYWORD
  init_pair(10, RGB(255,192,192), COLOR_BLACK); // SYNTAX_STRING
  init_pair(11, RGB(192,255,128), COLOR_BLACK); // SYNTAX_STRINGVAR
  init_pair(12, COLOR_BLACK, COLOR_CYAN);       // COLOR_MESSAGE (maps to COLOR_SELECTION)
  init_pair(13, COLOR_WHITE, COLOR_RED);        // COLOR_TOPLINE (maps to SYNTAX_ERROR)
  init_pair(14, RGB(192,192,0), COLOR_BLACK);   // SYNTAX_FUNC2
  */
}

RHEA_PreviewEditor::~RHEA_PreviewEditor()
{}

void RHEA_PreviewEditor::SetParent(HWND parent)
{
  m_parent = parent;
}

void RHEA_PreviewEditor::ClearText()
{
  m_curs_x = 0;
  m_curs_y = 0;
  m_text.Empty(true);
  m_undoStack.Empty(true);
}

int RHEA_PreviewEditor::onChar(int c)
{
  if (m_ui_state == UI_STATE_SEARCH)
  {
    return WDL_CursesEditor::onChar(c);
  }

  if (c == '\t')
  {
    if (RHEA_CTRL_KEY_DOWN)
    {
      SendMessage(m_parent, WM_TOGGLE_FOCUS, 2, 0);
      return 0;
    }
  }

  if (c == 'G' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN) return WDL_CursesEditor::onChar(c);
  }

  if (c == 'P' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN) return WDL_CursesEditor::onChar(c);
  }

  if (c == 'O' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN) return WDL_CursesEditor::onChar(c);
  }

  if (c == 'W' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN) { DestroyWindow(m_parent); return 0; }
  }

  if (c == 'F' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN) return WDL_CursesEditor::onChar(c);
  }

  if (c == 'C' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN) return WDL_CursesEditor::onChar(c);
  }

  if (c == 'L' - 'A' + 1)
  {
    return WDL_CursesEditor::onChar(c);
  }

  if (c == 27)
  {
    return WDL_CursesEditor::onChar(c);
  }

  if (c == KEY_DOWN || c == KEY_UP || c == KEY_PPAGE || c == KEY_NPAGE ||
    c == KEY_RIGHT || c == KEY_LEFT || c == KEY_HOME || c == KEY_END ||
    c == KEY_F1 || c == KEY_F2 || c == KEY_F3 || c == KEY_F4 || c == KEY_F5 ||
    c == KEY_F6 || c == KEY_F7 || c == KEY_F8 || c == KEY_F9 || c == KEY_F10 ||
    c == KEY_F11 || c == KEY_F12)
  {
    return WDL_CursesEditor::onChar(c);
  }

  return 0;
}

RHEA_PreferencesEditor::RHEA_PreferencesEditor(void *curses_ctx)
  : WDL_CursesEditor(curses_ctx)
{
  m_indent_size = 2;
}

RHEA_PreferencesEditor::~RHEA_PreferencesEditor()
{}

void RHEA_PreferencesEditor::SetParent(HWND parent)
{
  m_parent = parent;
}

void RHEA_PreferencesEditor::ClearText()
{
  m_curs_x = 0;
  m_curs_y = 0;
  m_text.Empty(true);
  m_undoStack.Empty(true);
}

int RHEA_PreferencesEditor::onChar(int c)
{
  if (c == '\t')
  {
    if (RHEA_CTRL_KEY_DOWN)
    {
      SendMessage(m_parent, WM_TOGGLE_FOCUS, 1, 0);
      return 0;
    }
  }

  if (c == 'W' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN)
    {
      DestroyWindow(m_parent);
      return 0;
    }
  }

  if (c == 'S' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN)
    {
      int len = 0;

      for (int i = 0; i < m_text.GetSize(); i++)
      {
        len += m_text.Get(i)->GetLength();
      }

      WDL_String prefs("", len);

      for (int i = 0; i < m_text.GetSize(); i++)
      {
        prefs.AppendFormatted(1024, "%s\n", m_text.Get(i)->Get());
      }

      cJSON_Minify(prefs.Get());
      cJSON *root = cJSON_Parse(prefs.Get());

      if (!root)
      {
        WDL_FastString err;

        const char *error_ptr = cJSON_GetErrorPtr();
        if (error_ptr)
        {
          err.SetFormatted(2048, "Parse error before: %s\n", error_ptr);
        }

        draw_message(err.Get());
      }
      else
      {
        updateFile();
        draw_message("Parsed and saved successfully");
      }

      cJSON_Delete(root);

      return 0;
    }
  }

  if (c == 'E' - 'A' + 1)
  {
    if (RHEA_CTRL_KEY_DOWN)
    {
      ShellExecute(m_parent, "", "notepad.exe", GetFileName(), "", SW_SHOWNORMAL);
    }
  }

  if (c == 27)
  {
    return WDL_CursesEditor::onChar(c);
  }

  //if (c == 27)
  //{
  //  DestroyWindow(m_parent);
  //  return 0;
  //}

  return WDL_CursesEditor::onChar(c);
}

void RHEA_PreferencesEditor::draw_bottom_line()
{
#define BOLD(x) { attrset(COLOR_BOTTOMLINE|A_BOLD); addstr(x); attrset(COLOR_BOTTOMLINE&~A_BOLD); }
  BOLD("S");
  addstr("ave");

  BOLD(" E");
  addstr("xternal");
#undef BOLD
}
