// Copyright (c) 2023 Giorgos Vougioukas
//
// The license can be found in the LICENSE file.

#include "rhea/library_wnd.h"

RHEA_LibraryWnd::RHEA_LibraryWnd()
  : m_hwnd(NULL)
{}

RHEA_LibraryWnd::~RHEA_LibraryWnd()
{}

void RHEA_LibraryWnd::OnInitDialog(WPARAM wparam, LPARAM lparam)
{}

void RHEA_LibraryWnd::OnDestroy(WPARAM wparam, LPARAM lparam)
{}

void RHEA_LibraryWnd::OnSize(WPARAM wparam, LPARAM lparam)
{
  if (wparam != SIZE_MINIMIZED)
  {
    m_resize.onResize();
  }
}

void RHEA_LibraryWnd::OnCommand(WPARAM wparam, LPARAM lparam)
{}

WDL_DLGRET RHEA_LibraryWnd::LibraryWndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
  RHEA_LibraryWnd *self = (RHEA_LibraryWnd *)GetWindowLongPtr(hwnd, GWLP_USERDATA);

  if (!self && msg == WM_INITDIALOG)
  {
    SetWindowLongPtr(hwnd, GWLP_USERDATA, lparam);
    self = (RHEA_LibraryWnd *)lparam;
    self->m_hwnd = hwnd;
  }

  if (WDL_likely(self))
  {
    return self->LibraryWndLoop(msg, wparam, lparam);
  }
  else
  {
    return 0;
  }
}

WDL_DLGRET RHEA_LibraryWnd::LibraryWndLoop(UINT msg, WPARAM wparam, LPARAM lparam)
{
  switch (msg)
  {
    case WM_INITDIALOG: OnInitDialog(wparam, lparam); break;
    case WM_DESTROY: OnDestroy(wparam, lparam); break;
    case WM_SIZE: OnSize(wparam, lparam); break;
    case WM_COMMAND: OnCommand(wparam, lparam); break;
  }

  return 0;
}
